import 'package:flutter/material.dart';
import 'package:gmalpha_flutter/MessageModel/service/MessageRepository.dart';
import 'package:gmalpha_flutter/MessageModel/service/remote/entity/FocusPageEntity.dart';

import 'package:gmalpha_flutter/commonModel/live/BaseModel.dart';
import 'package:gmalpha_flutter/commonModel/live/LiveData.dart';
import 'package:gmalpha_flutter/commonModel/toast/toast.dart';


enum DataStatus {
  DATA,
  NODATA
}

class FocusModel extends BaseModel{
  LiveData<FocusPageEntity> focusLive = LiveData();
  List<Followers> _newList = [];

  int page;
  final int count = 10;
  final int type = 1;
  final String fromPage;
  FocusModel(this.page, this.fromPage);

  @override
    void dispose() {
      focusLive.dispost();
  }

  void init(BuildContext context,{Function callback}){
    DataStatus loadStatus = DataStatus.DATA;
    MessageRepository.getInstance()
        .getFocusPage(type, page, count)
        .listen((value) {
      if (value != null) {
        if (value.data.followers.length == 0) {
          loadStatus = DataStatus.NODATA;
        }
        _newList.addAll(value.data.followers);
        value.data.followers = _newList;
        focusLive.notifyView(value);
        if (callback is Function) {
          callback(loadStatus);
        }
      }
    }).onError((error) {
      Toast.show(context, "${error.toString()}");
      print(error);
    });
  }

  refresh(BuildContext context) {
    page = 1;
    _newList = [];
    init(context);
  }

  more(BuildContext context, Function fun) {
    page++;
    init(context, callback: fun);
  }
}




 
