class FocusPageEntity {
  int error;
  String message;
  Null extra;
  Data data;

  FocusPageEntity({this.error, this.message, this.extra, this.data});

  FocusPageEntity.fromJson(Map<String, dynamic> json) {
    error = json['error'];
    message = json['message'];
    extra = json['extra'];
    data = json['data'] != null ? new Data.fromJson(json['data']) : null;
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['error'] = this.error;
    data['message'] = this.message;
    data['extra'] = this.extra;
    if (this.data != null) {
      data['data'] = this.data.toJson();
    }
    return data;
  }
}

class Data {
  List<Followers> followers;

  Data({this.followers});

  Data.fromJson(Map<String, dynamic> json) {
    if (json['followers'] != null) {
      followers = new List<Followers>();
      json['followers'].forEach((v) {
        followers.add(new Followers.fromJson(v));
      });
    }
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    if (this.followers != null) {
      data['followers'] = this.followers.map((v) => v.toJson()).toList();
    }
    return data;
  }
}

class Followers {
  int id;
  String icon;
  String username;
  bool isFollow;
  double followTime;

  Followers(
      {this.id, this.icon, this.username, this.isFollow, this.followTime});

  Followers.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    icon = json['icon'];
    username = json['username'];
    isFollow = json['is_follow'];
    followTime = json['follow_time'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['id'] = this.id;
    data['icon'] = this.icon;
    data['username'] = this.username;
    data['is_follow'] = this.isFollow;
    data['follow_time'] = this.followTime;
    return data;
  }
}