class LatestMessageEntity {
  int error;
  String message;
  Null extra;
  Data data;

  LatestMessageEntity({this.error, this.message, this.extra, this.data});

  LatestMessageEntity.fromJson(Map<String, dynamic> json) {
    error = json['error'];
    message = json['message'];
    extra = json['extra'];
    data = json['data'] != null ? new Data.fromJson(json['data']) : null;
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['error'] = this.error;
    data['message'] = this.message;
    data['extra'] = this.extra;
    if (this.data != null) {
      data['data'] = this.data.toJson();
    }
    return data;
  }
}

class Data {
  int id;
  String title;
  String content;
  String icon;
  double pushTime;
  String url;
  String pushTimeStr;
  User user;

  Data(
      {this.id,
      this.title,
      this.content,
      this.icon,
      this.pushTime,
      this.url,
      this.pushTimeStr,
      this.user});

  Data.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    title = json['title'];
    content = json['content'];
    icon = json['icon'];
    pushTime = json['push_time'];
    url = json['url'];
    pushTimeStr = json['push_time_str'];
    user = json['user'] != null ? new User.fromJson(json['user']) : null;
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['id'] = this.id;
    data['title'] = this.title;
    data['content'] = this.content;
    data['icon'] = this.icon;
    data['push_time'] = this.pushTime;
    data['url'] = this.url;
    data['push_time_str'] = this.pushTimeStr;
    if (this.user != null) {
      data['user'] = this.user.toJson();
    }
    return data;
  }
}

class User {
  int id;
  String name;

  User({this.id, this.name});

  User.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    name = json['name'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['id'] = this.id;
    data['name'] = this.name;
    return data;
  }
}