class MessageDate {
  final double time;
  int _currentDate;
  MessageDate(this.time);

  String diffTime() {
    var date = DateTime.now();
    int serverTime = (time * 1000).toInt();
    _currentDate = date.millisecondsSinceEpoch;
    int minuteDifference = ((_currentDate - serverTime) / 1000 / 60).floor();
    int hourDifference = ((_currentDate - serverTime) / 1000 / 60 / 60).ceil();
    int dayDifference = ((_currentDate - serverTime) / 1000 / 60 / 60 / 24).ceil();
    if (hourDifference < 24) {
      if (minuteDifference < 1) {
        return '刚刚';
      } else if (minuteDifference < 60) {
        return '$minuteDifference分钟前';
      }
      return '$hourDifference小时前';
    } else if (hourDifference > 24 && hourDifference < 48) {
      return '昨天前';
    } else {
      int currentYear = DateTime.fromMillisecondsSinceEpoch(serverTime).year;
      int currentDay = DateTime.fromMillisecondsSinceEpoch(serverTime).day;
      int currentMonth = DateTime.fromMillisecondsSinceEpoch(serverTime).month;
      String currentDay2 = currentDay < 10 ? '0$currentDay' : '$currentDay';
      String currentMonth2 = currentMonth < 10 ? '0$currentMonth' : '$currentMonth';
      if (dayDifference < 365) {
        return '$currentMonth2-$currentDay2';
      } else {
        return '$currentYear-$currentMonth2-$currentDay2';
      }
    }
  }
}