/*
 * @author lsy
 * @date   2019-10-15
 **/
import 'dart:convert';

import 'package:flutter/cupertino.dart';
import 'package:flutter/foundation.dart';
import 'package:gmalpha_flutter/commonModel/GMBase.dart';
import 'package:gmalpha_flutter/commonModel/toast/toast.dart';
import 'package:gmalpha_flutter/commonModel/util/IsolateUtil.dart';
import 'package:gmalpha_flutter/UserModel/page/country/CountryJson.dart';
import 'package:gmalpha_flutter/UserModel/service/UserRepository.dart';
import 'package:gmalpha_flutter/UserModel/service/remote/entity/CountryBean.dart';

class CountryModel extends BaseModel {
  LiveData<CountryBean> liveData = new LiveData();

  final String refer;
  String selectCity;

  CountryModel(this.refer);

  getCountries(BuildContext context) {
//    getStaticCountry().then((value) {
//      if (value != null) {
//        liveData.notifyView(value);
//      } else {
//        getCountryFromNet(context);
//      }
//    }).catchError((error) {
//      Toast.debugShow(context, error);
//      print(error);
//    });

    paseJson().then((value) {
      if (value != null) {
        liveData.notifyView(value);
      }
    });
  }

  getCountryFromNet(BuildContext context) {
    UserRepository.getInstance().getCountries().listen((value) {
      liveData.notifyView(value);
    }).onError((error) {
      Toast.debugShow(context, error);
      print(error);
    });
  }

  Future paseJson() async {
    return await compute(pase, 1);
  }

  @override
  void dispose() {
    liveData.dispost();
  }
}

CountryBean pase(int a) {
  return CountryBean.fromJson(json.decode(STATIC_COUNTRY_JSON));
}
