/*
 * @author lsy
 * @date   2019-09-04
 **/

import 'dart:async';
import 'dart:io';

import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:flutter_boost/flutter_boost.dart';
import 'package:gmalpha_flutter/commonModel/GMBase.dart';
import 'package:gmalpha_flutter/commonModel/live/BaseModel.dart';
import 'package:gmalpha_flutter/commonModel/net/Api.dart';
import 'package:gmalpha_flutter/commonModel/picker/loadingPicker.dart';
import 'package:gmalpha_flutter/commonModel/toast/toast.dart';
import 'package:gmalpha_flutter/UserModel/service/UserRepository.dart';
import 'package:gmalpha_flutter/UserModel/service/remote/entity/UserEntity.user.dart';
import 'package:gmalpha_flutter/UserModel/util/JumpUtil.dart';

import '../../../commonModel/live/LiveData.dart';

class UserSettingModel extends BaseModel {
  LiveData<String> nameLive = new LiveData();
  LiveData<String> cityLive = new LiveData();
  LiveData<String> headImgLive = new LiveData();
  LiveData<bool> saveLive = new LiveData();

  final String userid;
  final String refere;
  String selectImgPath, defultName, defultCity, cityId, age;

  UserSettingModel(this.userid, this.refere);

  init(BuildContext context) {
    UserEntityImpl().getuserId().listen((value) {
      print("VALUEE  $value");
      if (value == null || value != userid || value == "") {
        UserRepository.getInstance().getUserInfo(userid).listen((data) {
          print(data);
          nameLive.notifyView(data?.data?.nickName);
          cityLive.notifyView(data?.data?.countryInfo?.name);
          headImgLive.notifyView(data?.data?.profilePic);
          defultName = data?.data?.nickName;
          defultCity = data?.data?.countryInfo?.name;
          cityId = data?.data?.countryInfo?.id;
          age = data?.data?.age;
        }).onError((error) {
          print(error);
          Toast.show(context, error.toString());
        });
      } else {
        UserEntityImpl().getage().listen((data) {
          print("AGE  ${data}");
          age = data;
        }).onError((e) {
          Toast.show(context, e);
          print(e);
        });
        UserEntityImpl().getcityId().listen((data) {
          print("CITY ID  $data");
          cityId = data;
        }).onError((e) {
          Toast.debugShow(context, e);
          print(e);
        });
        UserEntityImpl().getnickName().listen((data) {
          print("NICK $data");
          defultName = data;
          nameLive.notifyView(data);
        }).onError((error) {
          print(error);
          Toast.debugShow(context, error);
        });
        UserEntityImpl().getcountryInfoName().listen((data) {
          print("con $data");
          defultCity = data;
          cityLive.notifyView(data);
        }).onError((error) {
          print(error);
          Toast.debugShow(context, error);
        });
        UserEntityImpl().getprofilePic().listen((value) {
          print("head $value");
          headImgLive.notifyView(value);
        }).onError((error) {
          print(error);
          Toast.debugShow(context, error);
        });
      }
    });
  }

  void detectUpdate() {
    if (defultName != nameLive.data ||
        defultCity != cityLive.data ||
        selectImgPath != null) {
      saveLive.notifyView(true);
    } else {
      saveLive.notifyView(false);
    }
  }

  @override
  void dispose() {
    nameLive.dispost();
    headImgLive.dispost();
    cityLive.dispost();
    saveLive.dispost();
  }

  void jumpToCAM(BuildContext context, String pageName) {
    clickEvent(pageName, "quit");
    jumpToCamera(context, pageName, Api.PROVIDER_NAME, true, 1, null)
        .then((value) {
      if (value != null) {
        print("$value");
        selectImgPath = value[0];
        File txt=File(selectImgPath);
        var dir_bool=txt.exists().then((value){
          print("RESULT！！！！！$selectImgPath   bool ${value}" );
        });

        headImgLive.notifyView(selectImgPath);
        detectUpdate();
      }
    }).catchError((error) {
      Toast.debugShow(context, error);
      print(error);
    });
  }

  void jumpToCTY(BuildContext context, String pageName) {
    jumpToCountry(context, pageName).then((value) {
      if (value != null) {
        print("COUNTRY  $value");
        cityId = value["countryId"];
        cityLive.notifyView(value["countryName"]);
        detectUpdate();
      }
    }).catchError((error) {
      Toast.debugShow(context, error.toString());
      print(error);
    });
  }

  void quit(BuildContext context, String pageName, VoidCallback dismiss) {
    clickEvent(pageName, "quit");
    UserRepository.getInstance().userLogout(userid).listen((value) {
      if (value != null) {
        quitNative(context, dismiss);
      }
    }).onError((error) {
      Toast.debugShow(context, error);
      print(error);
    });
  }

  void quitNative(BuildContext context, VoidCallback dismiss) {
    userLogout().listen((value) {
      if (value) {
        dismiss();
        Navigator.pop(context);
      }
    }).onError((error) {
      Toast.debugShow(context, error);
      print(error);
    });
  }

  void save(BuildContext context) {
    if (selectImgPath != null) {
      UserRepository.getInstance().getUploadToken(1).listen((data) {
        uploadImage(context, data.data?.token);
      }).onError((error) {
        Toast.show(context, "网络错误");
        print(error);
      });
    } else {
      settingInfo(context, headImgLive.data, nameLive.data, cityId);
    }
  }

  void uploadImage(BuildContext context, String token) {
    if (token == null) {
      Toast.debugShow(context, " token is null");
    } else {
      uploadImg(selectImgPath, token).listen((value) {
        print("UPLOAD --> $value");
        if (value != null) {
          settingInfo(context, "http://alpha.iyanzhi.com/${value}-w",
              nameLive.data, cityId);
        } else {
          Toast.show(context, "上传失败");
        }
      }).onError((e) {
        Toast.debugShow(context, e);
        print(e);
      });
    }
  }

  void settingInfo(
      BuildContext context, String head, String name, String countryId) {
    UserRepository.getInstance()
        .settingUserInfo(countryId, name, head, userid, age)
        .listen((data) {
      if (data != null) {
        Navigator.pop(context);
        UserEntityImpl().saveage(data?.data?.age);
        UserEntityImpl().saveprofilePic(head);
        UserEntityImpl().savenickName(name);
        UserEntityImpl().savecountryInfoId(countryId);
        UserEntityImpl().savecountryInfoName(cityLive.data);
        Timer(Duration(milliseconds: 100), () {
          FlutterBoost.singleton.closePageForContext(context);
//          Navigator.pop(context);
        });
//        FlutterBoost.singleton.closePageForContext(context);
//        Navigator.pop(context,"");
      } else {
        Toast.show(context, "保存失败");
      }
    }).onError((e) {
      Toast.show(context, e.toString());
      print(e);
    });
  }

  void onNameChange(String text) {
    if (text != null && text.isNotEmpty) {
      nameLive.data = text;
      detectUpdate();
    }
  }
}
