/*
 * @author lsy
 * @date   2019-09-04
 **/
import 'package:gmalpha_flutter/commonModel/net/Responce/SimpleResponce.dart';
import 'package:gmalpha_flutter/UserModel/service/local/UserLocal.dart';
import 'package:gmalpha_flutter/UserModel/service/remote/UserRemote.dart';
import 'package:gmalpha_flutter/UserModel/service/remote/entity/CommentBean.dart';
import 'package:gmalpha_flutter/UserModel/service/remote/entity/CountryBean.dart';
import 'package:gmalpha_flutter/UserModel/service/remote/entity/PrestigeEntity.dart';
import 'package:gmalpha_flutter/UserModel/service/remote/entity/SetUserBean.dart';
import 'package:gmalpha_flutter/UserModel/service/remote/entity/TestUserEntity.dart';
import 'package:gmalpha_flutter/UserModel/service/remote/entity/UploadTokenBean.dart';
import 'package:gmalpha_flutter/UserModel/service/remote/entity/UserEntity.dart';
import 'package:gmalpha_flutter/UserModel/service/remote/entity/UserEntity.user.dart';
import 'package:gmalpha_flutter/UserModel/service/remote/entity/UserResultBean.dart';
import 'package:rxdart/rxdart.dart';

class UserRepository {
  UserRemote _remote;
  UserLocal _local;

  static UserRepository _userRepository;

  UserRepository._() {
    _remote = UserRemote.getInstance();
    _local = UserLocal.getInstance();
  }

  static UserRepository getInstance() {
    if (_userRepository == null) {
      _userRepository = UserRepository._();
    }
    return _userRepository;
  }

  Observable<UserResultBean> getUserInfo(String userId) {
    return _remote.getUserInfo(userId).map((value) {
      if (value != null) {
        _local.saveUserInfo(value);
      }
      return value;
    });
  }

  Observable<CommentBean> commentSuggest(String content, String phone) {
    return _remote.commentSuggest(content, phone);
  }

  Observable<CountryBean> getCountries() {
    return _remote.getCountrise();
  }

  Observable<UploadTokenBean> getUploadToken(int token_type) {
    return _remote.getUploadToken(token_type);
  }

  Observable<SetUserBean> settingUserInfo(String country_id, String nick_name,
      String profile_pic, String user_id, String age) {
    return _remote.settingUserInfo(
        country_id, nick_name, profile_pic, user_id, age);
  }

  Observable<SimpleResponce> userLogout(String userID) {
    return _remote.userLogout(userID).map((value){
      if(value!=null){
       _local.clearData();
      }
      return value;
    });
  }

  Observable<PrestigeEntity> getReputations(int userId) {
    return _remote.getReputations(userId).map((value) {
      if (value != null) {
      }
      return value;
    });
  }
}
