/*
 * @author lsy
 * @date   2019-09-04
 **/
import 'package:gmalpha_flutter/commonModel/net/Responce/SimpleResponce.dart';
import 'package:gmalpha_flutter/UserModel/service/remote/api/UserApi.serv.dart';
import 'package:gmalpha_flutter/UserModel/service/remote/entity/CommentBean.dart';
import 'package:gmalpha_flutter/UserModel/service/remote/entity/PrestigeEntity.dart';
import 'package:gmalpha_flutter/UserModel/service/remote/entity/SetUserBean.dart';
import 'package:gmalpha_flutter/UserModel/service/remote/entity/TestUserEntity.dart';
import 'package:gmalpha_flutter/UserModel/service/remote/entity/UploadTokenBean.dart';
import 'package:gmalpha_flutter/UserModel/service/remote/entity/UserEntity.dart';
import 'package:gmalpha_flutter/UserModel/service/remote/entity/UserResultBean.dart';
import 'package:rxdart/rxdart.dart';

import 'entity/CountryBean.dart';

class UserRemote {
  static UserRemote _userRemote;

  UserRemote._() {}

  static UserRemote getInstance() {
    if (_userRemote == null) {
      _userRemote = new UserRemote._();
    }
    return _userRemote;
  }

  Observable<UserResultBean> getUserInfo(String userID) {
    return UserApiImpl().getUserInfo(userID);
  }

  Observable<CommentBean> commentSuggest(String content, String phone) {
    return UserApiImpl().comment(content, phone);
  }

  Observable<CountryBean> getCountrise() {
    return UserApiImpl().getCountrys();
  }

  Observable<UploadTokenBean> getUploadToken(int token_type) {
    return UserApiImpl().getUploadToken(token_type);
  }

  Observable<SetUserBean> settingUserInfo(String country_id, String nick_name,
      String profile_pic, String user_id, String age) {
    return UserApiImpl()
        .settingUserInfo(country_id, nick_name, profile_pic, user_id, age);
  }

  Observable<SimpleResponce> userLogout(String userId) {
    return UserApiImpl().logout(userId);
  }

  Observable<PrestigeEntity> getReputations(int userId) {
    return UserApiImpl().getReputations(userId);
  }
}
