// GENERATED CODE - DO NOT MODIFY BY HAND

// **************************************************************************
// ServiceGenerator
// **************************************************************************

import 'dart:convert';

import 'dart:io';

import 'package:rxdart/rxdart.dart';

import 'package:dio/dio.dart';

import 'package:flutter/foundation.dart';

import 'package:gmalpha_flutter/UserModel/service/remote/entity/UserResultBean.dart';
import 'package:gmalpha_flutter/UserModel/service/remote/entity/CommentBean.dart';
import 'package:gmalpha_flutter/UserModel/service/remote/entity/CountryBean.dart';
import 'package:gmalpha_flutter/UserModel/service/remote/entity/UploadTokenBean.dart';
import 'package:gmalpha_flutter/UserModel/service/remote/entity/SetUserBean.dart';
import 'package:gmalpha_flutter/commonModel/net/Responce/SimpleResponce.dart';
import 'package:gmalpha_flutter/UserModel/service/remote/entity/PrestigeEntity.dart';

import 'package:gmalpha_flutter/commonModel/net/DioUtil.dart';

class UserApiImpl {
  factory UserApiImpl() => _sharedInstance();

  static UserApiImpl _instance;

  UserApiImpl._() {}

  static UserApiImpl _sharedInstance() {
    if (_instance == null) {
      _instance = UserApiImpl._();
    }
    return _instance;
  }

  Observable<UserResultBean> getUserInfo(String userID) {
    return Observable.fromFuture(DioUtil().get('api/account/user_profile',
        data: {'user_id': userID})).flatMap((value) {
      if (value != null && value.statusCode == 200) {
        return Observable.fromFuture(
            compute(paseUserResultBean, value.toString()));
      } else {
        return Observable.fromFuture(null);
      }
    });
  }

  Observable<CommentBean> comment(String content, String phone) {
    return Observable.fromFuture(DioUtil().post('api/v1/suggestion',
        data: {'content': content, 'phone': phone})).flatMap((value) {
      if (value != null && value.statusCode == 200) {
        return Observable.fromFuture(
            compute(paseCommentBean, value.toString()));
      } else {
        return Observable.fromFuture(null);
      }
    });
  }

  Observable<CountryBean> getCountrys() {
    return Observable.fromFuture(DioUtil().get('api/v1/countries'))
        .flatMap((value) {
      if (value != null && value.statusCode == 200) {
        return Observable.fromFuture(
            compute(paseCountryBean, value.toString()));
      } else {
        return Observable.fromFuture(null);
      }
    });
  }

  Observable<UploadTokenBean> getUploadToken(int token_type) {
    return Observable.fromFuture(DioUtil().post('api/v1/app/upload_token',
        data: {'token_type': token_type})).flatMap((value) {
      if (value != null && value.statusCode == 200) {
        return Observable.fromFuture(
            compute(paseUploadTokenBean, value.toString()));
      } else {
        return Observable.fromFuture(null);
      }
    });
  }

  Observable<SetUserBean> settingUserInfo(String country_id, String nick_name,
      String profile_pic, String user_id, String age) {
    return Observable.fromFuture(
        DioUtil().post('api/account/user_settle', data: {
      'country_id': country_id,
      'nick_name': nick_name,
      'profile_pic': profile_pic,
      'user_id': user_id,
      'age': age
    })).flatMap((value) {
      if (value != null && value.statusCode == 200) {
        return Observable.fromFuture(
            compute(paseSetUserBean, value.toString()));
      } else {
        return Observable.fromFuture(null);
      }
    });
  }

  Observable<SimpleResponce> logout(String user_id) {
    return Observable.fromFuture(
            DioUtil().post('api/account/logout/', data: {'user_id': user_id}))
        .flatMap((value) {
      if (value != null && value.statusCode == 200) {
        return Observable.fromFuture(
            compute(paseSimpleResponce, value.toString()));
      } else {
        return Observable.fromFuture(null);
      }
    });
  }

  Observable<PrestigeEntity> getReputations(int userId) {
    return Observable.fromFuture(
            DioUtil().get('api/v1/reputations', data: {'user_id': userId}))
        .flatMap((value) {
      if (value != null && value.statusCode == 200) {
        return Observable.fromFuture(
            compute(pasePrestigeEntity, value.toString()));
      } else {
        return Observable.fromFuture(null);
      }
    });
  }
}

UserResultBean paseUserResultBean(String value) {
  return UserResultBean.fromJson(json.decode(value));
}

CommentBean paseCommentBean(String value) {
  return CommentBean.fromJson(json.decode(value));
}

CountryBean paseCountryBean(String value) {
  return CountryBean.fromJson(json.decode(value));
}

UploadTokenBean paseUploadTokenBean(String value) {
  return UploadTokenBean.fromJson(json.decode(value));
}

SetUserBean paseSetUserBean(String value) {
  return SetUserBean.fromJson(json.decode(value));
}

SimpleResponce paseSimpleResponce(String value) {
  return SimpleResponce.fromJson(json.decode(value));
}

PrestigeEntity pasePrestigeEntity(String value) {
  return PrestigeEntity.fromJson(json.decode(value));
}
