/*
 * @author lsy
 * @date   2019-09-16
 **/
class PrestigeEntity {
  int error;
  String message;
  Null extra;
  Data data;

  PrestigeEntity({this.error, this.message, this.extra, this.data});

  PrestigeEntity.fromJson(Map<String, dynamic> json) {
    error = json['error'];
    message = json['message'];
    extra = json['extra'];
    data = json['data'] != null ? new Data.fromJson(json['data']) : null;
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['error'] = this.error;
    data['message'] = this.message;
    data['extra'] = this.extra;
    if (this.data != null) {
      data['data'] = this.data.toJson();
    }
    return data;
  }
}

class Data {
  List<Introduce> introduce;
  List<Reputations> reputations;

  Data({this.introduce, this.reputations});

  Data.fromJson(Map<String, dynamic> json) {
    if (json['introduce'] != null) {
      introduce = new List<Introduce>();
      json['introduce'].forEach((v) {
        introduce.add(new Introduce.fromJson(v));
      });
    }
    if (json['reputations'] != null) {
      reputations = new List<Reputations>();
      json['reputations'].forEach((v) {
        reputations.add(new Reputations.fromJson(v));
      });
    }
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    if (this.introduce != null) {
      data['introduce'] = this.introduce.map((v) => v.toJson()).toList();
    }
    if (this.reputations != null) {
      data['reputations'] = this.reputations.map((v) => v.toJson()).toList();
    }
    return data;
  }
}

class Introduce {
  String question;
  String answer;

  Introduce({this.question, this.answer});

  Introduce.fromJson(Map<String, dynamic> json) {
    question = json['question'];
    answer = json['answer'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['question'] = this.question;
    data['answer'] = this.answer;
    return data;
  }
}

class Reputations {
  String category;
  List<ExpertTags> expertTags;

  Reputations({this.category, this.expertTags});

  Reputations.fromJson(Map<String, dynamic> json) {
    category = json['category'];
    if (json['expert_tags'] != null) {
      expertTags = new List<ExpertTags>();
      json['expert_tags'].forEach((v) {
        expertTags.add(new ExpertTags.fromJson(v));
      });
    }
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['category'] = this.category;
    if (this.expertTags != null) {
      data['expert_tags'] = this.expertTags.map((v) => v.toJson()).toList();
    }
    return data;
  }
}

class ExpertTags {
  int tagId;
  String tagName;
  String grayBadge;
  String lightBadge;
  int level;

  ExpertTags(
      {this.tagId, this.tagName, this.grayBadge, this.lightBadge, this.level});

  ExpertTags.fromJson(Map<String, dynamic> json) {
    tagId = json['tag_id'];
    tagName = json['tag_name'];
    grayBadge = json['gray_badge'];
    lightBadge = json['light_badge'];
    level = json['level'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['tag_id'] = this.tagId;
    data['tag_name'] = this.tagName;
    data['gray_badge'] = this.grayBadge;
    data['light_badge'] = this.lightBadge;
    data['level'] = this.level;
    return data;
  }
}