/*
 * @author lsy
 * @date   2019-10-16
 **/
class SetUserBean {
  int error;
  String message;
  Null extra;
  Data data;
  UserType userType;

  SetUserBean({this.error, this.message, this.extra, this.data, this.userType});

  SetUserBean.fromJson(Map<String, dynamic> json) {
    error = json['error'];
    message = json['message'];
    extra = json['extra'];
    data = json['data'] != null ? new Data.fromJson(json['data']) : null;
    userType = json['user_type'] != null
        ? new UserType.fromJson(json['user_type'])
        : null;
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['error'] = this.error;
    data['message'] = this.message;
    data['extra'] = this.extra;
    if (this.data != null) {
      data['data'] = this.data.toJson();
    }
    if (this.userType != null) {
      data['user_type'] = this.userType.toJson();
    }
    return data;
  }
}

class Data {
  int id;
  bool isOnline;
  int userId;
  String nickName;
  String profilePic;
  int gender;
  String age;
  String cityId;
  String countryId;
  double birth;
  bool isBind;

  Data(
      {this.id,
      this.isOnline,
      this.userId,
      this.nickName,
      this.profilePic,
      this.gender,
      this.age,
      this.cityId,
      this.countryId,
      this.birth,
      this.isBind});

  Data.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    isOnline = json['is_online'];
    userId = json['user_id'];
    nickName = json['nick_name'];
    profilePic = json['profile_pic'];
    gender = json['gender'];
    age = json['age'];
    cityId = json['city_id'];
    countryId = json['country_id'];
    birth = json['birth'];
    isBind = json['is_bind'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['id'] = this.id;
    data['is_online'] = this.isOnline;
    data['user_id'] = this.userId;
    data['nick_name'] = this.nickName;
    data['profile_pic'] = this.profilePic;
    data['gender'] = this.gender;
    data['age'] = this.age;
    data['city_id'] = this.cityId;
    data['country_id'] = this.countryId;
    data['birth'] = this.birth;
    data['is_bind'] = this.isBind;
    return data;
  }
}

class UserType {
  UserType();

  UserType.fromJson(Map<String, dynamic> json) {}

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    return data;
  }
}
