/*
 * @author dx
 * @date   2019-09-17
 **/
import 'package:flutter/material.dart';
import 'package:gmalpha_flutter/WebModel/service/ActivityReportRepository.dart';
import 'package:gmalpha_flutter/WebModel/service/remote/entity/ActivityReportEntity.dart';
import 'package:gmalpha_flutter/commonModel/live/BaseModel.dart';
import 'package:gmalpha_flutter/commonModel/live/LiveData.dart';
import 'package:gmalpha_flutter/commonModel/net/DioUtil.dart';
import 'package:gmalpha_flutter/commonModel/toast/toast.dart';

class ActivityReportModel extends BaseModel {
  LiveData<ActivityReportEntity> activityReportLive = new LiveData();

  final int id;
  final int type;
  final String fromPage;

  ActivityReportModel(this.id, this.type, this.fromPage);

  init(BuildContext context) {
    ActivityReportRepository.getInstance()
        .getActivityReport(id, type)
        .listen((value) {
      if (value != null) {
        activityReportLive.notifyView(value);
      }
    }).onError((error) {
      Toast.show(context, "${error.toString()}");
      print(error);
    });
  }

  @override
  void dispose() {
    activityReportLive.dispost();
  }
}
