/*
 * @author dx
 * @date   2019-09-17
 **/

import 'package:gmalpha_flutter/WebModel/service/local/ActivityReportLocal.dart';
import 'package:gmalpha_flutter/WebModel/service/remote/ActivityReportRemote.dart';
import 'package:gmalpha_flutter/WebModel/service/remote/entity/ActivityReportEntity.dart';
import 'package:rxdart/rxdart.dart';

class ActivityReportRepository {
  ActivityReportRemote _remote;
  ActivityReportLocal _local;

  static ActivityReportRepository _userRepository;

  ActivityReportRepository._() {
    _remote = ActivityReportRemote.getInstance();
    _local = ActivityReportLocal.getInstance();
  }

  static ActivityReportRepository getInstance() {
    if (_userRepository == null) {
      _userRepository = ActivityReportRepository._();
    }
    return _userRepository;
  }

  Observable<ActivityReportEntity> getActivityReport(int id, int type) {
    return _remote.getActivityReport(id, type).map((value) {
      if (value != null) {
      }
      return value;
    });
  }
}
