/*
 * @author dx
 * @date   2019-09-17
 **/
class ActivityReportEntity {
  int error;
  String message;
  Null extra;
  Data data;

  ActivityReportEntity({this.error, this.message, this.extra, this.data});

  ActivityReportEntity.fromJson(Map<String, dynamic> json) {
    error = json['error'];
    message = json['message'];
    extra = json['extra'];
    data = json['data'] != null ? new Data.fromJson(json['data']) : null;
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['error'] = this.error;
    data['message'] = this.message;
    data['extra'] = this.extra;
    if (this.data != null) {
      data['data'] = this.data.toJson();
    }
    return data;
  }
}

class Data {
  String surveyRecordId;
  Report report;

  Data({this.surveyRecordId, this.report});

  Data.fromJson(Map<String, dynamic> json) {
    surveyRecordId = json['survey_record_id'];
    report =
        json['report'] != null ? new Report.fromJson(json['report']) : null;
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['survey_record_id'] = this.surveyRecordId;
    if (this.report != null) {
      data['report'] = this.report.toJson();
    }
    return data;
  }
}

class Report {
  Share share;
  List<Cards> cards;

  Report({this.share, this.cards});

  Report.fromJson(Map<String, dynamic> json) {
    share = json['share'] != null ? new Share.fromJson(json['share']) : null;
    if (json['cards'] != null) {
      cards = new List<Cards>();
      json['cards'].forEach((v) {
        cards.add(new Cards.fromJson(v));
      });
    }
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    if (this.share != null) {
      data['share'] = this.share.toJson();
    }
    if (this.cards != null) {
      data['cards'] = this.cards.map((v) => v.toJson()).toList();
    }
    return data;
  }
}

class Share {
  int totalCost;
  int beat;
  int rank;

  Share({this.totalCost, this.beat, this.rank});

  Share.fromJson(Map<String, dynamic> json) {
    totalCost = json['total_cost'];
    beat = json['beat'];
    rank = json['rank'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['total_cost'] = this.totalCost;
    data['beat'] = this.beat;
    data['rank'] = this.rank;
    return data;
  }
}

class Cards {
  int id;
  String name;
  String guide;
  String protocol;
  List<Drafts> drafts;

  Cards({this.id, this.name, this.guide, this.protocol, this.drafts});

  Cards.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    name = json['name'];
    guide = json['guide'];
    protocol = json['protocol'];
    if (json['drafts'] != null) {
      drafts = new List<Drafts>();
      json['drafts'].forEach((v) {
        drafts.add(new Drafts.fromJson(v));
      });
    }
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['id'] = this.id;
    data['name'] = this.name;
    data['guide'] = this.guide;
    data['protocol'] = this.protocol;
    if (this.drafts != null) {
      data['drafts'] = this.drafts.map((v) => v.toJson()).toList();
    }
    return data;
  }
}

class Drafts {
  Null id;
  String content;
  String image;

  Drafts({this.id, this.content, this.image});

  Drafts.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    content = json['content'];
    image = json['image'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['id'] = this.id;
    data['content'] = this.content;
    data['image'] = this.image;
    return data;
  }
}