import 'dart:async';
import 'dart:convert';

import 'package:flutter/material.dart';
import 'package:flutter_boost/flutter_boost.dart';
import 'package:gmalpha_flutter/Annotations/RouterCenterRestore.mark.dart';
import 'package:gmalpha_flutter/Error_Page.dart';
import 'package:gmalpha_flutter/TestPage.dart';

import 'commonModel/GMBase.dart';
import 'res/value/ALColors.dart';

void main() {
  initParams(() {
    runZoned(() {
      runApp(MyApp());
    }, onError: (Object obj, StackTrace stack) {
      var details = makeDetails(obj, stack);
      reportError(details);
    });
  });
}

void reportError(FlutterErrorDetails details) {
  print("flutter error ==> $details");
}

class MyApp extends StatefulWidget {
  @override
  _MyAppState createState() => _MyAppState();
}

class _MyAppState extends State<MyApp> {
  var buildOnce = FlutterBoost.init(postPush:
      (String pageName, String uniqueId, Map params, Route route, Future _) {
    print("FLUTTER PUSHED $pageName");
  });

  @override
  void initState() {
    super.initState();
    FlutterBoost.singleton.registerPageBuilders({
      'comment_suggest': (pageName, params, _) {
        return RouterCenterImpl()
            .findUserRouter()
            ?.getCommentPage(params["fromPage"]);
      },
      'message_home': (pageName, params, _) {
        print("PARAMS!! ${params}");
        return RouterCenterImpl()
            .findNewMessageRouter()
            ?.getMessagePage(params["fromPage"]);
      },
      'album': (pageName, params, _) {
        if (params == null) {
          return ErrorPage("出错：需要传递的参数为空");
        }
        return RouterCenterImpl().findAlbumRouter().getAlbumPage(
            params["provider"] as String,
            params["needCamera"] == null
                ? true
                : params["needCamera"] == "0" ? true : false,
            params["maxCount"] == null ? 1 : int.parse(params["maxCount"]),
            params["selectedPath"] == null
                ? null
                : new List<String>.from(params["selectedPath"]),
            true,
            params["fromPage"] == null ? "" : params["fromPage"],
            maxVideoCount: params["maxVideoCount"] == null
                ? 0
                : int.parse(params["maxVideoCount"]),
            videoSelectPath: params["videoSelectedPath"] == null
                ? null
                : new List<String>.from(params["videoSelectedPath"]),
            iosPushedPage: params["iosPushedPage"] == null
                ? null
                : params["iosPushedPage"]);
      },
      "prestige": (pageName, params, _) {
        print("PARAMS!! ${params}");
        int userId = int.parse(params["userId"]);
        return RouterCenterImpl().findUserRouter()?.getReputationsPage(
            userId, params["userName"], params["fromPage"]);
      },
      "user_setting": (pageName, params, _) {
        print("PARAMS!! ${params}");
        return RouterCenterImpl()
            .findUserRouter()
            ?.getUserSettingPage(params["userId"] ?? "", params["fromPage"]);
      },
      "activity_report": (pageName, params, _) {
        print("PARAMS!! ${params}");
        return RouterCenterImpl()
            .findWebRouter()
            ?.getActivityReportPage(
                params["survey_record_id"] == null
                    ? null
                    : int.parse(params["survey_record_id"]),
                params["template_id"] == null
                    ? null
                    : int.parse(params["template_id"]),
                params["fromPage"]);
      },
      "message_focus": (pageName, params, _) {
        return RouterCenterImpl()
            .findNewMessageRouter()
            ?.getFocusPage(params["fromPage"]);
      },
      "message_attention": (pageName, params, _) {
        return RouterCenterImpl()
            .findNewMessageRouter()
            ?.getAttentionPage(params["fromPage"]);
      },
      "message_like": (pageName, params, _) {
        return RouterCenterImpl()
            .findNewMessageRouter()
            ?.getLikePage(params["fromPage"]);
      },
       'find_home': (pageName, params, _) {
        if (!Api.getInstance().setDioCookie(params) ||
            params["fromPage"] == null) {
          return ErrorPage("出错：需要传递的参数为空");
        }
        return RouterCenterImpl()
            .findFindRouter()
            ?.getFindPage(params["fromPage"]);
      },
    });
    FlutterBoost.handleOnStartPage();
  }

  @override
  Widget build(BuildContext context) {
    return MaterialApp(
        title: 'Flutter Boost example',
        debugShowCheckedModeBanner: false,
        routes: {
          '/': (context) {
            return TestPage();
          },
        },
        builder: buildOnce,
        theme: new ThemeData(
          primaryColor: Colors.white,
          backgroundColor: ALColors.ColorFFFFFF,
          accentColor: ALColors.ColorE4E4E4,
          textTheme: TextTheme(
            //设置Material的默认字体样式
            body1: TextStyle(color: Color(0xFF888888), fontSize: 16.0),
          ),
          iconTheme: IconThemeData(
            color: Color(0xFFEFEFEF),
            size: 35.0,
          ),
        ));
  }
}
