//
//  opinion
//
//  gmalpha_flutter
//  Created by Mikasa on 2019/2/19.
//  Copyright © 2019 Gengmei. All rights reserved.
//  意见与建议页面

import 'package:dio/dio.dart';
import 'package:flutter_boost/flutter_boost.dart';
import 'package:flutter/material.dart';
import 'macros/ALColors.dart';
import 'macros/ALDevice.dart';
import 'netWork/DioUtil.dart';
import 'toast/toast.dart';

class CommentSuggest extends StatelessWidget {
  final Map params;
  CommentSuggest(this.params);

  Widget build(BuildContext context) {
    return MaterialApp(
      debugShowCheckedModeBanner: false,
      title: '意见与建议',
      color: Color(0xFFffffff),
      theme: ThemeData(
        splashColor: Colors.white10, //水波纹的颜色
      ),
      home: CommentSuggestPage(nativeCookie: this.params,title: '意见与建议',)
    );
  }
}

class CommentSuggestPage extends StatefulWidget  {

  final String title;
  final Map nativeCookie; 

  CommentSuggestPage({Key key, this.title, this.nativeCookie}) : super(key: key);

  @override
  _CommentSuggestPageState createState() => _CommentSuggestPageState();
}

class _CommentSuggestPageState extends State<CommentSuggestPage> {
  TextEditingController opinionCtrl = TextEditingController();
  TextEditingController telCtrl = TextEditingController();

  @override
  Widget build(BuildContext context) {
    return Scaffold(
        appBar: AppBar(
          backgroundColor: Color(0xFFffffff),
          title: Text('意见与建议',
                      style: new TextStyle(fontSize: 16.0,color: ALColors.Color323232),
                    ),
          elevation: 0,
          brightness: Brightness.light,
          leading: new GestureDetector(
              child: new ImageIcon(
                AssetImage('images/nav_back.png'),
                color: ALColors.Color323232,
              ),
              onTap: () {
                print('123-------');
                // FlutterBoost.singleton.closePageForContext(context);
                FlutterBoost.singleton.closePageForContext(context);
              }),
        ),
        body: new SingleChildScrollView(
          child: Center(
            child: Column(
              // mainAxisAlignment: MainAxisAlignment.start,
              children: <Widget>[
                Container(
                  alignment: Alignment.topCenter,
                  margin:
                      EdgeInsets.only(left: 30, top: 50, right: 30, bottom: 0),
                  height: 215,
                  decoration: BoxDecoration(
                    border: Border.all(color: ALColors.ColorC4C4C4, width: 1),
                  ),
                  child: TextField(
                    maxLines: 10,
                    controller: opinionCtrl,
                    decoration: InputDecoration(
                      border: InputBorder.none,
                      contentPadding: EdgeInsets.all(10),
                      hintText: '意见与建议',
                      hintStyle: TextStyle(
                        color: ALColors.ColorC4C4C4,
                        fontSize: 14,
                      ),
                      labelStyle:
                          TextStyle(color: ALColors.Color323232, fontSize: 19),
                    ),
                  ),
                ),
                Container(
                  height: 30,
                  margin: EdgeInsets.only(left: 30, right: 30, top: 40),
                  // padding: EdgeInsets.only(bottom: 10),
                  decoration: BoxDecoration(
                    border: Border(
                    bottom: BorderSide(color: ALColors.ColorC4C4C4),
                  )),
                  alignment: Alignment.centerLeft,
                  child: TextField(
                    controller: telCtrl,
                    decoration: InputDecoration(
                      border: InputBorder.none,
                      contentPadding: EdgeInsets.all(10),
                      hintText: '联系方式',
                      hintStyle: TextStyle(
                        color: ALColors.ColorC4C4C4,
                        fontSize: 14,
                      ),
                      labelStyle:
                          TextStyle(color: ALColors.Color323232, fontSize: 19),
                    ),
                  ),
                ),
                Container(
                  alignment: Alignment.bottomCenter,
                  decoration: BoxDecoration(
                      border:
                          Border.all(color: ALColors.Color323232, width: 1.5)),
                  margin: EdgeInsets.only(left: 30, right: 30, bottom: 30, top: 180),
                  // padding: EdgeInsets.all(0),
                  constraints:
                      BoxConstraints(minWidth: ALDevice.width, minHeight: 45),
                  child: FlatButton(
                    onPressed: confirmClick,
                    child: Text(
                      '提交',
                      style:
                          TextStyle(fontSize: 14, color: ALColors.Color323232),
                    ),
                  ),
                ),
              ],
            ),
          ),
        ));
  }
  void confirmClick() {

    confimSuggestInfo();
    
  }

  void confimSuggestInfo()  {
    BaseOptions options = DioUtil.getDefOptions();
    final cookie = new Map<String, dynamic>.from(widget.nativeCookie);
    HttpConfig config = new HttpConfig(options: options, nativeCookie: cookie);
    DioUtil.openDebug();
    DioUtil().setConfig(config);
    String content = (this.opinionCtrl.text.length > 0)? this.opinionCtrl.text : '';
    String phone = (this.telCtrl.text.length > 0)? this.telCtrl.text : '';
    DioUtil().requestR(Method.post, "api/v1/suggestion",data: {"content": content, "phone": phone}).then((res){
      if (res.code == 0) {
        Toast.show(context, '提交成功');
        FlutterBoost.singleton.closePageForContext(context);
      } else {
        Toast.show(context, res.msg); 
      }
    }
    ).then((error){
      if (error != null) {
        Toast.show(context, '提交失败');
         print(error);
      } else {
        // FlutterBoost.singleton.closePageForContext(context);
      }

    });
  }

}

