
import 'package:flutter/material.dart';
import 'package:gmalpha_flutter/model/message/replied_content.dart';

// The base class for the different types of items the list can contain.
abstract class ListItem {}

class Message implements ListItem {
  final int userId;
  final String name;
  final String icon;
  final num time;
  final String content;
  final int id;
  // final String repliedContent;
  final RepliedContent repliedContent;

  Message(
      {this.userId,
      this.name,
      this.icon,
      this.time,
      this.content,
      this.id,
      this.repliedContent,
    });

  factory Message.fromJson(Map<String, dynamic> json) {
    return Message(
      userId: json['user_id'],
      name: json['name'],
      icon: json['icon'],
      id: json['id'],
      time: json['time'],
      content: json['content'],
      repliedContent: json['replied_content'] != null ? new RepliedContent.fromJson(json['replied_content']):null,
    );
  }

  Map<String, dynamic> toJson() {
		final Map<String, dynamic> data = new Map<String, dynamic>();
		data['user_id'] = this.userId;
		data['name'] = this.name;
		data['icon'] = this.icon;
		data['id'] = this.id;
		data['time'] = this.time;
		data['content'] = this.content;
		if (this.repliedContent != null) {
      data['replied_content'] = this.repliedContent.toJson();
    }
		return data;
	}
}

class NotificationItem implements ListItem {
  String icon;
  String content;
  int count;
  String title;

  NotificationItem(this.icon, this.content, this.count, this.title);
}


