import 'dart:convert';

import 'package:flutter/material.dart';
import 'package:gmalpha_flutter/model/message/message.dart' as prefix0;
import 'package:gmalpha_flutter/pages/message/home/message_notification_item.dart';
import 'message_item.dart';
import 'package:gmalpha_flutter/model/message/message.dart';
import 'package:gmalpha_flutter/netWork/DioUtil.dart';
import 'package:gmalpha_flutter/toast/toast.dart';
import 'package:flutter_easyrefresh/easy_refresh.dart';
import 'package:flutter/semantics.dart';

class MessageHomePage extends StatefulWidget {
  @override
  _MessageHomePageState createState() => _MessageHomePageState();
}

class _MessageHomePageState extends State<MessageHomePage> with AutomaticKeepAliveClientMixin {

  List<ListItem> messageList = List<ListItem>();
  List<ListItem>  dataArr = List<ListItem>();

  @override
  bool get wantKeepAlive => true;

  Future<List<ListItem>> _fetchMesssageList() async {
    List<Message> messageList = List<Message>();
    print('aaaaa');
    BaseResp<List> baseresp = await DioUtil().request<List>(Method.get, "api/v1/reply/my", queryParameters: {'page': 1, 'count': 10});
    if (baseresp.code != 0) {
      return new Future.error(baseresp.msg);
    }
    
    if (baseresp.data != null) {
      messageList = baseresp.data.map((value) {
        return Message.fromJson(value);
      }).toList();
    }
    return messageList;
  }

   Future<List<ListItem>>  _fetchNewestInfo() async {
    print('---------start----------');
    List<ListItem>  notiData = List<ListItem>();
    BaseRespR noteResp =  await DioUtil().requestR(Method.get, 'api/v1/push/newest/info'); 
    Map noteData = noteResp.data;
    String noteContent = noteData['content'];
    NotificationItem noteItem = NotificationItem('images/message_noti.png', noteContent, 0, '通知');
    notiData.add(noteItem);

    BaseRespR likeResp = await DioUtil().requestR(Method.get, 'api/v1/message/unread',queryParameters: {'type': 0});
    print(likeResp);
    Map likeData = likeResp.data;
    String likeContent = '还没有人给你Like哦~';
    NotificationItem likeItem = NotificationItem('images/message_like.png', likeContent, likeData['count'], 'Like');
    if (likeItem.count > 0) {
      likeItem.content = '有${likeItem.content}个人Like了你';
    }
    notiData.add(likeItem);

    BaseRespR attentionResp = await DioUtil().requestR(Method.get, 'api/v1/message/unread',queryParameters: {'type': 1});
    Map attData = attentionResp.data;
    String attContent = '还没有人给你关注哦~';
    NotificationItem attItem = NotificationItem('images/message_att.png', attContent, attData['count'], '关注');
    if (attItem.count > 0) {
      attItem.content = '有${attItem.content}个人关注了你';
    }
    notiData.add(attItem);
    // this.dataArr = dataArr;
    return notiData;
  }

   Future<List<ListItem>> _fetchListData() async {
     print('---------start---------');
     List<ListItem>  dataArr = List<ListItem>();
     dataArr = await _fetchNewestInfo();
     print(dataArr);
     List<ListItem> messageData = await _fetchMesssageList();
     messageData.forEach((item) {
       dataArr.add(item);
     });
     print(dataArr);
     print('---------end---------');
    return dataArr;
   }

  @override
  Widget build(BuildContext context) {
    return new Scaffold(
      appBar: new AppBar(
        title: new Text('消息'),
      ),
      floatingActionButton: new FloatingActionButton(
          onPressed: () {
            _fetchListData();
          },
          child: new Icon(Icons.add_box),
          elevation: 3.0,
          highlightElevation: 2.0,
          backgroundColor: Colors.red,        // 红色
        ),
      
      body: new Center(
        child: FutureBuilder(
        future: _fetchListData(),
        builder: (context, snapshot) {
          switch (snapshot.connectionState) {
            case ConnectionState.none:
            case ConnectionState.waiting:
              break;
            default:
             if (snapshot.hasData) {
                return _createListView(context, snapshot);
              }
          }
        },
      ),
      )
    );
  }
  

  Widget _createListView(BuildContext context, AsyncSnapshot snapshot) {
    List<ListItem> dataArr = snapshot.data;
    return ListView.builder(
      shrinkWrap: true,
      key: new PageStorageKey('message-list'),
      itemCount: dataArr.length,
      itemBuilder: (BuildContext context, int index) {
        ListItem  item = dataArr[index];
        if (item is Message) {
          return new MessageItem(onPressed: (){}, message:item);
        } else if (item is NotificationItem){
          return new MessageNotificationItem(onPressed: (){}, notification: item);
        }

      },
    );
  }

  }