import 'package:flutter/material.dart';
import 'package:gmalpha_flutter/model/message/message.dart';

class MessageItem extends StatelessWidget {
  final Message message;
  VoidCallback onPressed;

  MessageItem({Key key, this.message, this.onPressed}) : super(key: key);
  @override
  Widget build(BuildContext context) {
    var thumbImg = new Container(
      width: 42,
      height: 42,
      decoration: BoxDecoration(
        shape: BoxShape.circle,
        image: new DecorationImage(
          image: new NetworkImage(message.icon),
        )
      ),
    );

    var contentImg = new Container(
      width: 48,
      height: 48,
      decoration: BoxDecoration(
        image: new DecorationImage(
          image: new NetworkImage(message.repliedContent.content),
        )
      ),
    );

    var titleRow = new Row (
      children: <Widget>[
        new Row (
           mainAxisAlignment: MainAxisAlignment.start,
           children: <Widget>[ 
              Text(message.name, style: TextStyle(color: Color(0xff323232), fontWeight: FontWeight.bold, fontSize: 13)),
              new Padding (
              padding: EdgeInsets.only(left: 8, right: 8),
              child:   Text('评论了你', style: TextStyle(color: Color(0xff323232), fontSize: 13)),
             )
           ],
         ),
      ],
    );

    String timeStr() {
      DateTime dateTime = DateTime.fromMicrosecondsSinceEpoch((message.time*1000*1000).toInt(), isUtc: false);
      String time = dateTime.toString();
      time = time.substring("yyyy-".length, "yyyy-MM-dd".length);
      return time;
    } 

    var contenRow = new Row (
      mainAxisAlignment: MainAxisAlignment.start,
      children: <Widget>[
       new Expanded(
          child: new Text(message.content, maxLines: 2, textAlign: TextAlign.start, overflow: TextOverflow.ellipsis, style: TextStyle(color: Color(0xff323232), fontSize: 13, )),
        )
      ],
      // mainAxisSize: ,
      // children: <Widget>[
      // ],
      // padding: EdgeInsets.only(right: ),
    //  mainAxisAlignment: MainAxisAlignment.start, 
    );


    var timeRow = new Row(
      children: <Widget>[
       new Text(timeStr(), maxLines: 1, overflow: TextOverflow.ellipsis, style: TextStyle(color: Color(0xff8e8e8e), fontSize: 10, )),
      ],
    );

    return new GestureDetector(
      onTap: onPressed,
      // onTap: timeStr(),
      child: new Container(
          child: new Column(
            children: <Widget>[
              new Row(
                children: <Widget>[
                    new Padding(
                      padding: const EdgeInsets.only(left: 16, top: 20),
                      child: new Container(
                        child: new Center(
                          child: thumbImg,
                        ),
                      ),
                    ),
                    new Expanded(
                      flex: 1,
                      child: new Padding(
                        padding: const EdgeInsets.only(left: 10,right: 10, top: 10, bottom: 10),
                        child: new Column(
                          mainAxisAlignment: MainAxisAlignment.start,
                          children: <Widget>[
                            titleRow,
                            // Text(message.content, maxLines: 2, textAlign: TextAlign.left, overflow: TextOverflow.ellipsis, style: TextStyle(color: Color(0xff323232), fontSize: 13, )),
                            contenRow,
                            timeRow,
                          ],
                        ),
                      ),
                    ),
                    new Padding(
                      padding: const EdgeInsets.only(right: 16),
                      child: new Container(
                        child: new Center(
                            child: contentImg,
                        ),
                      ),
                    )
                  ],
              )
            ],
          ),
      ),
    );
  }
}
