import 'package:flutter/services.dart';


// flutter 埋点方案 
class PhobosFlutter {
    static const MethodChannel _channel =
      const MethodChannel('phobos_flutter_plugin');

  ///
  /// track
  /// 灰度信息
  ///
  /// @param  GreyType 事件名.
  ///
  /// 使用示例：
  /// PhobosFlutter.getGreyType();
  ///
    static Future<String> get getGreyType async {
      return await _channel.invokeMethod('getGreyType');
    }

    ///当前API
    static Future<String> get getServerAPI async {
      return await _channel.invokeMethod('getServerAPI');
    }

    /// signingType 包的类型
    static Future<String> get getSigningType async {
      return await _channel.invokeMethod('getServerAPI');
    }

    /// userId
    static Future<String> get getUserId async {
      return await _channel.invokeMethod('getUserId');
    }


  ///
  /// track
  /// 事件追踪
  ///
  /// @param eventName  String 事件名.
  /// @param properties Map<String,dynamic> 事件属性.
  ///
  /// 使用示例：
  /// PhobosFlutter.track('eventname',{'key1':'value1','key2':'value2'});
  ///
  static void track(String eventName ,Map<String, dynamic> properties ) {
    assert(eventName != null);
    List<dynamic> params = [eventName,properties];
    _channel.invokeMethod('track',params);
  }

  static void trackSendNow(String eventName ,Map<String, dynamic> properties ) {
    assert(eventName != null);
    List<dynamic> params = [eventName,properties];
    _channel.invokeMethod('track',params);
  }


}