import 'package:flutter/material.dart';
import 'package:gmalpha_flutter/NewMessageModel/service/remote/entity/AttentionEntity.dart';
import 'package:gmalpha_flutter/NewMessageModel/service/MessageRepository.dart';
import 'package:gmalpha_flutter/commonModel/live/BaseModel.dart';
import 'package:gmalpha_flutter/commonModel/live/LiveData.dart';
import 'package:gmalpha_flutter/commonModel/toast/toast.dart';

enum DataStatus {
  DATA,
  NODATA
}

class AttentionModel extends BaseModel {
  LiveData<AttentionEntity> attentiveLive = new LiveData();
  List<Data> _newList = [];

  int page;
  final int count = 10;
  final String fromPage;

  AttentionModel(this.page, this.fromPage);

  init(BuildContext context, {Function callback}) {
    DataStatus loadStatus = DataStatus.DATA;
    MessageRepository.getInstance().getAttentionList(page, count).listen((value) {
      if (value != null) {
        // 增加一个字段，用来判断是否还有数据
        if (value.data.length == 0) {
          loadStatus = DataStatus.NODATA;
        }
        _newList.addAll(value.data);
        value.data = _newList;
        attentiveLive.notifyView(value);
        if (callback is Function) {
          callback(loadStatus);
        }
      }
    }).onError((error) {
      Toast.show(context, "${error.toString()}");
      print(error);
    });
  }

  refresh(BuildContext context) {
    page = 1;
    _newList = [];
    init(context);
  }

  more(BuildContext context, Function fun) {
    page++;
    init(context, callback: fun);
  }

  @override
  void dispose() {
    attentiveLive.dispost();
  }
}
