import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:flutter_screenutil/flutter_screenutil.dart';
import 'package:flutter_svg/flutter_svg.dart';
import 'package:gmalpha_flutter/NewMessageModel/page/attention/AttentionListItem.dart';
import 'package:gmalpha_flutter/NewMessageModel/page/attention/AttentionModel.dart';
import 'package:gmalpha_flutter/NewMessageModel/service/remote/entity/AttentionEntity.dart';
import 'package:gmalpha_flutter/commonModel/base/BaseComponent.dart';
import 'package:gmalpha_flutter/commonModel/base/BasePage.dart';
import 'package:gmalpha_flutter/res/value/ALColors.dart';
import 'package:pull_to_refresh/pull_to_refresh.dart';

import 'package:gmalpha_flutter/commonModel/base/BaseComponent.dart';

double width15 = ScreenUtil.instance.setWidth(15.0);
double width16 = ScreenUtil.instance.setWidth(16.0);
double width10 = ScreenUtil.instance.setWidth(10.0);
double height16 = ScreenUtil.instance.setHeight(16.0);
double height10 = ScreenUtil.instance.setHeight(10.0);
double height20 = ScreenUtil.instance.setHeight(20.0);

class AttentionPage extends StatefulWidget {
  final AttentionModel _model;
  AttentionPage(String fromPage) : _model = AttentionModel(1, fromPage);
  @override
  _AttentionPageState createState() => _AttentionPageState(_model);
}

class _AttentionPageState extends BasePage<AttentionPage> {
  List<Data> _noticeLists = [];
  AttentionModel _model;
  _AttentionPageState(this._model);

  RefreshController _refreshController = RefreshController(initialRefresh: false);
  
  @override
  void initState() {
    super.initState();
    _model.init(context);
  }

  // 热更新代码
  @override
  void reassemble() {
    super.reassemble();
    _noticeLists = [];
    _model.refresh(context);
  }

  @override
  String pageName() {
    return 'notice_list';
  }

  @override
  String referrer() {
    return _model.fromPage;
  }

  Widget buildNoticeitem(BuildContext context, int index) {
    return Padding(
      padding: EdgeInsets.only(bottom: height16, top: height16, left: width15, right: width15),
      child: AttentionListItem(_noticeLists[index]),
    );
  }


  Widget _buildProgressIndicator({LoadStatus mode, String text}) {
    Widget loadText = Text(
      text,
      textAlign: TextAlign.center,
      style: TextStyle(
        color: ALColors.Color999999,
        fontSize: ScreenUtil.instance.setSp(14.0),
        height: 1.07
      ),
    );
    if (mode == LoadStatus.loading || mode == LoadStatus.canLoading) {
      return Container(
        color: Color(0xFFF4F3F8),
        child: Row(
          mainAxisAlignment: MainAxisAlignment.center,
          crossAxisAlignment: CrossAxisAlignment.center,
          children: <Widget>[
            Container(
              width: 15.0,
              height: 15.0,
              child: CircularProgressIndicator(strokeWidth: 2.0),
            ),
            Padding(
              padding: EdgeInsets.only(
                left: ScreenUtil.instance.setWidth(6.0),
                top: height20,
                bottom: height20
              ),
              child: loadText
            )
          ],
        )
      );
    } else {
      return Opacity(
        opacity: 1.0,
        child: Container(
          color: Color(0xFFF4F3F8),
          padding: EdgeInsets.only(
            left: ScreenUtil.instance.setWidth(6.0),
            top: height20,
            bottom: height20
          ),
          child: loadText
        ),
      );
    }
    
  }

  Widget loadingItem() {
    Widget loadCircle = Column(
      mainAxisAlignment: MainAxisAlignment.start,
      children: <Widget>[
        Container(
          padding: EdgeInsets.only(top: 60.0),
          child: CircularProgressIndicator(),
        ),
        Padding(
          padding: EdgeInsets.only(
            left: width10,
            right: width10,
            top: height10,
            bottom: height10
          ),
          child: Text('加载中...'),
        )
      ],
    );
    return SliverFillViewport(
      delegate: SliverChildListDelegate([loadCircle])
    );
  }

  Widget errorItem(String reason) {
    return SliverFillViewport(
      delegate: SliverChildListDelegate([
        Center(
          child: Text("$reason"),
        )
      ])
    );
  }

  @override
  Widget build(BuildContext context) {
    ScreenUtil.instance = ScreenUtil(width: 375.0, height: 667.0)..init(context);
    return Scaffold(
      backgroundColor: Colors.white,
      appBar: baseAppBar(
        backClick: (){
          Navigator.pop(context);
        }
      ),
      body: SmartRefresher(
        enablePullDown: false,
        enablePullUp: true,
        footer: CustomFooter(
          builder: (BuildContext context,LoadStatus mode){
            String body ;
            if (mode == LoadStatus.idle){
              body =  '上拉加载';
            } else if (mode==LoadStatus.loading || mode == LoadStatus.canLoading){
              body =  '加载中...';
            } else if (mode == LoadStatus.failed){
              body = '加载失败！点击重试！';
            } else if (mode == LoadStatus.noMore) {
              body = '暂时无更多数据!';
            }
            return _buildProgressIndicator(mode: mode, text: body);
          },
        ),
        controller: _refreshController,
        onLoading: _onLoading,
        child: CustomScrollView(
          slivers: <Widget>[
            SliverToBoxAdapter(
              child: topTitle(),
            ),
            renderList()
          ],
        )
      ),
    );
  }

  Widget renderList() {
    return StreamBuilder(
      stream: _model.attentiveLive.stream,
      initialData: _model.attentiveLive.data,
      builder: (context, data) {
        if (data.data == null) {
          return loadingItem();
        }
        if (data.data.error != 0 || data.data.data == null) {
          return errorItem(data.data.message);
        }
        if(data.data != null){
          _noticeLists = data.data.data;
        }
        return SliverList(
          delegate: SliverChildBuilderDelegate(
            (BuildContext context, int index) {
              return Container(
                padding: EdgeInsets.only(
                  bottom: height16,
                  top: height16,
                  left: width15,
                  right: width15
                ),
                child: AttentionListItem(_noticeLists[index]),
              );
            },
            childCount: _noticeLists.length,
          ),
        );
      },
    );
  }

  void _onLoading() {
    _model.more(context, (value) {
      if(value == DataStatus.NODATA) {
        _refreshController.loadNoData();
      } else {
        _refreshController.loadComplete();
      }
    });
  }

  Widget topTitle() {
    return Column(
      crossAxisAlignment: CrossAxisAlignment.start,
      children: <Widget>[
        Padding(
          padding: EdgeInsets.only(
            top: ScreenUtil.instance.setHeight(5.0),
            left: width16,
            right: width16,
            bottom: ScreenUtil.instance.setHeight(19.0)
          ),
          child: Text(
            '通知',
            style: TextStyle(fontSize: ScreenUtil.instance.setSp(20.0), color: ALColors.Color323232),
          ),
        ),
        Container(
          margin: EdgeInsets.only(left: width15, right: width15),
          child: Divider(
            height: 1.0,
            color: ALColors.ColorE4E4E4,
          ),
        )
      ],
    ); 
  }

  @override
  void dispose() {
    super.dispose();
    _model.dispose();
    _refreshController.dispose();
  }
}