import 'package:cached_network_image/cached_network_image.dart';
import 'package:flutter/material.dart';
import 'package:flutter_screenutil/flutter_screenutil.dart';
import 'package:gmalpha_flutter/NewMessageModel/service/remote/entity/FocusPageEntity.dart';
import 'package:gmalpha_flutter/commonModel/base/AppBase.dart';

import 'package:gmalpha_flutter/res/value/ALColors.dart';

class FocusListItem extends StatelessWidget {
  final Followers item;

  FocusListItem(this.item);
  
  Text myText(
    String text,
    Color color,
    double size,
    {int maxLines = 1, bool weight = false}
  ) {
    return Text(
      text,
      softWrap: true,
      maxLines: maxLines,
      overflow: TextOverflow.ellipsis,
      style: TextStyle(
        fontSize: ScreenUtil.instance.setSp(size),
        color: color,
        height: 1.38,
        fontWeight: weight ? FontWeight.bold : FontWeight.normal
      ),
    );
  }

  Widget listItemHead() {
    return ClipOval(
        child: Container(
      color: ALColors.ColorE4E4E4,
      child: CachedNetworkImage(
        width: 42.0,
        height: 42.0,
        imageUrl: item.icon,
        fit: BoxFit.cover,
      ),
    ));
  }

  Widget listItemInfo() {
    return Expanded(
      child: Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: <Widget>[
          Container(
            width:double.infinity,
            height: 42.0,
            decoration: BoxDecoration(color: ALColors.ColorFFFFFF),
            margin: EdgeInsets.only(left: ScreenUtil.instance.setWidth(10.0)),
            padding: EdgeInsets.only(top: ScreenUtil.instance.setHeight(10.0)),
            child: myText('${item.username??""}  关注了你', ALColors.Color666666, 13.0),
          ),
          
        ],
      ),
    );
  }

  @override
  Widget build(BuildContext context) {
    return GestureDetector(
        onTap: () {
          jumpToNative('url_page',
              {"url": 'alpha://user_detail?user_id=${item.id}'});
        },
        child: Container(
          child: Row(
            crossAxisAlignment: CrossAxisAlignment.start,
            children: <Widget>[
              listItemHead(),
              listItemInfo(),
            ],
          ),
        ));
  }
}

