import 'package:cached_network_image/cached_network_image.dart';
import 'package:flutter/material.dart';
import 'package:flutter_screenutil/flutter_screenutil.dart';
import 'package:gmalpha_flutter/NewMessageModel/page/common.dart';
import 'package:gmalpha_flutter/NewMessageModel/service/remote/entity/LikePageEntity.dart';
import 'package:gmalpha_flutter/NewMessageModel/util/message_date.dart';
import 'package:gmalpha_flutter/commonModel/base/AppBase.dart';
import 'package:gmalpha_flutter/res/value/ALColors.dart';

class LikeListItem extends StatelessWidget {
  final Data item;

  LikeListItem(this.item);

  Text myText(String text, Color color, double size,
      {int maxLines = 1, bool weight = false}) {
    return Text(
      text,
      softWrap: true,
      maxLines: maxLines,
      overflow: TextOverflow.ellipsis,
      style: TextStyle(
          fontSize: ScreenUtil.instance.setSp(size),
          color: color,
          height: 1.38,
          fontWeight: weight ? FontWeight.bold : FontWeight.normal),
    );
  }

  Widget listItemHead() {
    var businessId;
    if (item.likeContent != null) {
      businessId = item.likeContent.id.toString();
    } else {
      businessId = item.userId.toString();
    }
    return GestureDetector(
        onTap: () {
          onClickLike(
              'head_photo', {'business_id': businessId, 'tab_name': ''});
          jumpToNative('url_page',
              {"url": 'alpha://user_detail?user_id=${item.userId}'});
        },
        child: ClipOval(
            child: Container(
              color: ALColors.ColorE4E4E4,
                child: CachedNetworkImage(
                  width: 42.0,
                  height: 42.0,
                  imageUrl: item.icon,
                  fit: BoxFit.cover,
                ),
        )));
  }

  Widget listItemRight() {
    var commentImg;
    if (item.type != 2) {
      if (item.likeContent.content != null &&
          item.likeContent.contentType != 1) {
        commentImg = item.likeContent.content;
      }
      if (item.likeContent?.content == null &&
          item.likeContent.contentType != 1) {
        commentImg = 'http://alpha.iyanzhi.com/topic/2019/08/16/63ef62d019-w';
      }
    }
    var businessId;
    if (item.likeContent != null) {
      businessId = item.likeContent.id.toString();
    } else {
      businessId = item.userId.toString();
    }
    return GestureDetector(
        onTap: () {
          onClickLike('photo', {'business_id': businessId, 'tab_name': ''});
          if (item.likeContent.type == 0) {
            jumpToNative('url_page', {
              "url": "alpha://topic_detail?topic_id=${item.likeContent.id}"
            });
          } else if (item.likeContent.type == 1) {
            jumpToNative('url_page', {
              "url":
                  "alpha://topic_detail?call_keyboard=1&open_comment=1&topic_id=${item.likeContent.id}"
            });
          }
        },
        child: Container(
            child: Container(
          color: ALColors.ColorE4E4E4,
          child: CachedNetworkImage(
            width: 42.0,
            height: 42.0,
            imageUrl: commentImg,
            fit: BoxFit.cover,
          ),
        )));
  }

  Widget listItemInfo() {
    var commentInfo;
    var commenTime;
    var replyContent;
    var textTop;
    if (item.type != 2) {
      if (item.likeContent.type == 0) {
        commentInfo = '赞了你的回答';
      } else {
        commentInfo = '赞了你的评论';
      }
      commenTime = MessageDate(item.time).diffTime();
      if (item.type == 1) {
        replyContent = item.likeContent.replyContent;
      }
    }
    if (item.content != null) {
      textTop = 11.0;
    } else {
      textTop = 0.0;
    }
    var businessId;
    if (item.likeContent != null) {
      businessId = item.likeContent.id.toString();
    } else {
      businessId = item.userId.toString();
    }
    return Expanded(
        child: GestureDetector(
      onTap: () {
        onClickLike(
            'like_message', {'business_id': businessId, 'tab_name': ''});
        if (item.likeContent.type == 0) {
          jumpToNative('url_page',
              {"url": "alpha://topic_detail?topic_id=${item.likeContent.id}"});
        } else if (item.likeContent.type == 1) {
          jumpToNative('url_page', {
            "url":
                "alpha://topic_detail?call_keyboard=1&open_comment=1&topic_id=${item.likeContent.id}"
          });
        }
      },
      child: Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: <Widget>[
          Container(
            margin: EdgeInsets.only(left: ScreenUtil.instance.setWidth(10.0)),
            padding:
                EdgeInsets.only(top: ScreenUtil.instance.setHeight(textTop)),
            child: myText(
                '${item.name ?? ""}${item.content ?? ""}${commentInfo ?? ""}',
                ALColors.Color666666,
                13.0),
          ),
          item.type == 1
              ? Padding(
                  padding: EdgeInsets.only(
                      left: ScreenUtil.instance.setWidth(10.0),
                      top: ScreenUtil.instance.setHeight(3.0)),
                  child: myText(
                      '${replyContent ?? ""}', ALColors.Color999999, 10.0))
              : Container(),
          Padding(
              padding: EdgeInsets.only(
                  left: ScreenUtil.instance.setWidth(10.0),
                  top: ScreenUtil.instance.setHeight(3.0)),
              child: myText('${commenTime ?? ""}', ALColors.Color999999, 10.0))
        ],
      ),
    ));
  }

  Widget listItemButton() {
    return Container(
      padding: EdgeInsets.only(
          top: ScreenUtil.instance.setHeight(5.0),
          left: ScreenUtil.instance.setWidth(12.0)),
      width: ScreenUtil.instance.setWidth(54.0),
      height: ScreenUtil.instance.setHeight(29.0),
      child: OutlineButton(
          padding: const EdgeInsets.only(
            left: 0.0,
            right: 0.0,
          ),
          borderSide: BorderSide(color: ALColors.Color323232),
          shape: RoundedRectangleBorder(borderRadius: BorderRadius.zero),
          onPressed: () {
            jumpToNative('url_page', {
              "url":
                  "alpha://pictorial_detail?pictorial_id=${item.likeContent.id}&show_reply=${true}"
            });
          },
          child: myText('查看', ALColors.Color323232, 13.0)),
    );
  }

  @override
  Widget build(BuildContext context) {
    return Container(
      child: Row(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: <Widget>[
          listItemHead(),
          listItemInfo(),
          item.likeContent == null
              ? Container()
              : item.likeContent.type == 2 ? listItemButton() : listItemRight()
        ],
      ),
    );
  }
}
