import 'package:flutter/material.dart';
import 'package:gmalpha_flutter/NewMessageModel/service/MessageRepository.dart';
import 'package:gmalpha_flutter/NewMessageModel/service/remote/entity/LikePageEntity.dart';
import 'package:gmalpha_flutter/commonModel/live/BaseModel.dart';
import 'package:gmalpha_flutter/commonModel/live/LiveData.dart';
import 'package:gmalpha_flutter/commonModel/toast/toast.dart';


enum DataStatus {
  DATA,
  NODATA
}

class LikeModel extends BaseModel{
  LiveData<LikePageEntity> likeLive = LiveData();
  List<Data> _newList = [];

  int page;
  final int count = 10;
  final String fromPage;
  LikeModel(this.page, this.fromPage);

  @override
    void dispose() {
      likeLive.dispost();
  }

  void init(BuildContext context,{Function callback}){
    DataStatus loadStatus = DataStatus.DATA;
    MessageRepository.getInstance()
        .getLikePage(page, count)
        .listen((value) {
      if (value != null) {
        if (value.data.length == 0) {
          loadStatus = DataStatus.NODATA;
        }
        _newList.addAll(value.data);
        value.data = _newList;
        likeLive.notifyView(value);
        if (callback is Function) {
          callback(loadStatus);
        }
      }
    }).onError((error) {
      Toast.show(context, "${error.toString()}");
      print(error);
    });
  }

  refresh(BuildContext context) {
    page = 1;
    _newList = [];
    init(context);
  }

  more(BuildContext context, Function fun) {
    page++;
    init(context, callback: fun);
  }
}




 
