import 'package:flutter/cupertino.dart';
import 'package:flutter_screenutil/flutter_screenutil.dart';
import 'package:flutter_svg/flutter_svg.dart';
import 'package:gmalpha_flutter/Annotations/RouterCenterRestore.mark.dart';
import 'package:gmalpha_flutter/NewMessageModel/service/remote/entity/MyMessageEntity.dart';
import 'package:gmalpha_flutter/NewMessageModel/util/message_date.dart';
import 'package:gmalpha_flutter/commonModel/base/AppBase.dart';
import 'package:gmalpha_flutter/res/value/ALColors.dart';

messageTitle(String text) {
  return Text(text,
      textScaleFactor: 1.0,
      style: TextStyle(
          color: ALColors.Color323232,
          fontSize: ScreenUtil.instance.setSp(20)));
}

var width = ScreenUtil.instance.setWidth(16);

Widget messageTop(imgUrl, title, content, count) {
  var height = ScreenUtil().setHeight(12);
  return Container(
      padding: EdgeInsets.only(left: width, right: width),
      width: double.infinity,
      child: Stack(
        children: <Widget>[
          Container(
            padding: EdgeInsets.only(top: height, bottom: height),
            margin: EdgeInsets.only(left: ScreenUtil.instance.setWidth(4)),
            width: double.infinity,
            height: ScreenUtil.instance.setHeight(50),
            child: Row(
              children: <Widget>[
                Hero(
                    tag: "icon",
                    child: SvgPicture.asset(
                      imgUrl,
                      color: ALColors.Color323232,
                    )),
                SizedBox(
                  width: ScreenUtil.instance.setWidth(8),
                ),
                Text(title,
                    style: TextStyle(
                        color: ALColors.Color323232,
                        fontSize: ScreenUtil().setSp(13),
                        fontWeight: FontWeight.bold)),
                SizedBox(
                  width: ScreenUtil.instance.setWidth(16),
                ),
                Container(
                    width: ScreenUtil.instance.setWidth(200),
                    child: Text(content,
                        style: TextStyle(
                            color: ALColors.Color8E8E8E,
                            fontSize: ScreenUtil().setSp(13)),
                        maxLines: 1,
                        overflow: TextOverflow.ellipsis))
              ],
            ),
          ),
          getNum(count),
          Positioned(
            right: ScreenUtil.instance.setWidth(14),
            top: ScreenUtil.instance.setHeight(18),
            child: Hero(
                tag: "arrow_right",
                child: SvgPicture.asset(
                  "images/arrow_right.svg",
                  color: ALColors.Color323232,
                )),
          )
        ],
      ));
}

Widget getNum([int count]) {
  if (count > 0) {
    return Positioned(
      right: ScreenUtil.instance.setWidth(30),
      top: ScreenUtil.instance.setHeight(18),
      child: Container(
          padding: EdgeInsets.only(
              top: ScreenUtil.instance.setHeight(2),
              bottom: ScreenUtil.instance.setHeight(2),
              left: ScreenUtil.instance.setWidth(7),
              right: ScreenUtil.instance.setWidth(7)),
          decoration: BoxDecoration(
              color: ALColors.Color323232,
              borderRadius: BorderRadius.circular(22.0)),
          child: Text(
            count.toString(),
            style: TextStyle(
                color: ALColors.ColorFFFFFF,
                fontSize: ScreenUtil().setSp(11),
                height: 1.0),
          )),
    );
  } else {
    return Container();
  }
}

Widget messageList(Data list) {
  var content = {
    1: {
      'showText': '评论了你',
      'openUrl':
          'topic_detail?call_keyboard=1&open_comment=0&topic_id=${list.repliedContent.topicId}&reply_id=${list.id}'
    },
    2: {
      'showText': '评论了你的评论',
      'openUrl':
          'topic_detail?call_keyboard=1&open_comment=0&topic_id=${list.repliedContent.topicId}&reply_id=${list.id}'
    },
    3: {
      'showText': '评论了你',
      'openUrl':
          'pictorial_detail?pictorial_id=${list.repliedContent.pictorialId}&reply_id=${list.id}&show_reply=${false}'
    },
    4: {
      'showText': '评论了你的评论',
      'openUrl':
          'pictorial_detail?pictorial_id=${list.repliedContent.pictorialId}&reply_id=${list.id}&show_reply=${false}'
    },
    5: {
      'showText': '关注了你的问题',
      'openUrl':
          'pictorial_detail?pictorial_id=${list.repliedContent.pictorialId}'
    }
  };
  return Container(
      padding: EdgeInsets.only(left: width, right: width),
      margin: EdgeInsets.only(bottom: ScreenUtil.instance.setHeight(25)),
      child: Row(
        crossAxisAlignment: CrossAxisAlignment.start,
        mainAxisAlignment: MainAxisAlignment.spaceBetween,
        children: <Widget>[
          Row(
              crossAxisAlignment: CrossAxisAlignment.start,
              mainAxisAlignment: MainAxisAlignment.start,
              children: <Widget>[
                GestureDetector(
                    onTap: () {
                      onClickButton('head_photo',
                          {'business_id': list.userId.toString()});
                      jumpToNative('url_page', {
                        "url": 'alpha://user_detail?user_id=${list.userId}'
                      });
                    },
                    child: Container(
                        width: 42.0,
                        height: 42.0,
                        decoration: BoxDecoration(
                            shape: BoxShape.circle,
                            image: DecorationImage(
                                image: NetworkImage(list.icon))))),
                SizedBox(width: ScreenUtil.instance.setWidth(10)),
                GestureDetector(
                    onTap: () {
                      onClickButton('comment');
                      messagePopPicker({
                        "show_like": list.isLike,
                        "commment_id": "${list.id}",
                        "page_name": "message_home",
                        "topic_id": "${list.repliedContent.topicId}",
                        "user_name": list.name,
                        "pictorial_id": list.repliedContent.pictorialId == null
                            ? null
                            : list.repliedContent.pictorialId
                      });
                    },
                    child: Container(
                        child: Column(
                            crossAxisAlignment: CrossAxisAlignment.start,
                            mainAxisAlignment: MainAxisAlignment.start,
                            children: <Widget>[
                          Row(
                            children: <Widget>[
                              Text(list.name,
                                  style: TextStyle(
                                      color: ALColors.Color323232,
                                      fontSize: ScreenUtil().setSp(13),
                                      fontWeight: FontWeight.bold)),
                              SizedBox(width: ScreenUtil.instance.setWidth(10)),
                              Text(
                                  content[list.repliedContent?.type]
                                      ['showText'],
                                  style: TextStyle(
                                      color: ALColors.Color323232,
                                      fontSize: ScreenUtil().setSp(13)))
                            ],
                          ),
                          Container(
                            width: ScreenUtil.instance.setWidth(210),
                            child: Text(list.content,
                                style: TextStyle(
                                    color: ALColors.Color323232,
                                    fontSize: ScreenUtil().setSp(13)),
                                maxLines: 1,
                                overflow: TextOverflow.ellipsis),
                          ),
                          Text(MessageDate(list.time).diffTime(),
                              style: TextStyle(
                                  color: Color(0xfff8e8e8e),
                                  fontSize: ScreenUtil().setSp(10)))
                        ])))
              ]),
          GestureDetector(
              onTap: () {
                onClickButton('photo',
                    {'business_id': list.repliedContent.id.toString()});
                jumpToNative('url_page', {
                  "url":
                      'alpha://${content[list.repliedContent?.type]['openUrl']}'
                });
                // jumpToNative('url_page', {
                //   "url":
                //       'alpha://topic_detail?topic_id=${list.repliedContent.topicId}'
                // });
              },
              child: Container(
                width: ScreenUtil.instance.setWidth(48),
                height: ScreenUtil.instance.setHeight(48),
                child: Image.network(
                    list.repliedContent.content != null
                        ? list.repliedContent.content
                        : 'http://alpha.iyanzhi.com/topic/2019/08/16/63ef62d019-w',
                    width: ScreenUtil.instance.setWidth(48),
                    height: ScreenUtil.instance.setHeight(48)),
              ))
        ],
      ));
}

void onClickButton(buttonName, [params]) {
  RouterCenterImpl().findBuriedRouter()?.onEvent('on_click_button',
      {'page_name': 'message_home', 'button_name': buttonName, ...?params});
}
