import 'package:gmalpha_flutter/NewMessageModel/service/local/MessageLocal.dart';
import 'package:gmalpha_flutter/NewMessageModel/service/remote/MessageRemote.dart';
import 'package:gmalpha_flutter/NewMessageModel/service/remote/entity/FocusPageEntity.dart';
import 'package:gmalpha_flutter/NewMessageModel/service/remote/entity/LatestMessageEntity.dart';
import 'package:gmalpha_flutter/NewMessageModel/service/remote/entity/LikePageEntity.dart';
import 'package:gmalpha_flutter/NewMessageModel/service/remote/entity/MyMessageEntity.dart';
import 'package:gmalpha_flutter/NewMessageModel/service/remote/entity/UnreadMessageEntity.dart';
import 'package:gmalpha_flutter/NewMessageModel/service/remote/entity/AttentionEntity.dart';
import 'package:rxdart/rxdart.dart';

class MessageRepository {
  MessageRemote _remote;
  MessageLocal _local;

  static MessageRepository _userRepository;

  MessageRepository._() {
    _remote = MessageRemote.getInstance();
    _local = MessageLocal.getInstance();
  }

  static MessageRepository getInstance() {
    if (_userRepository == null) {
      _userRepository = MessageRepository._();
    }
    return _userRepository;
  }

  Observable<MyMessageEntity> getMyMessage(int page, int count) {
    return _remote.getMyMessage(page, count).map((value) {
      if (value != null) {
      }
      return value;
    });
  }

  Observable<UnreadMessageEntity> getUnreadMessage(int type) {
    return _remote.getUnreadMessage(type).map((value) {
      if (value != null) {
      }
      return value;
    });
  }

  Observable<LatestMessageEntity> getLatestMessage() {
    return _remote.getLatestMessage().map((value) {
      if (value != null) {
      }
      return value;
    });
  }

  Observable<AttentionEntity> getAttentionList(int page, int count) {
    return _remote.getAttentionList(page, count).map((value) {
      if (value != null) {
      }
      return value;
    });
  }

  Observable<LikePageEntity> getLikePage(int page, int count) {
    return _remote.getLikePage(page, count).map((value) {
      if (value != null) {
      }
      return value;
    });
  }

  Observable<FocusPageEntity> getFocusPage(int type,int page, int count) {
    return _remote.getFocusPage(type, page, count).map((value) {
      if (value != null) {
      }
      return value;
    });
  }
}