import 'package:gmalpha_flutter/NewMessageModel/service/remote/api/MessageApi.serv.dart';
import 'package:gmalpha_flutter/NewMessageModel/service/remote/entity/FocusPageEntity.dart';
import 'package:gmalpha_flutter/NewMessageModel/service/remote/entity/LatestMessageEntity.dart';
import 'package:gmalpha_flutter/NewMessageModel/service/remote/entity/LikePageEntity.dart';
import 'package:gmalpha_flutter/NewMessageModel/service/remote/entity/MyMessageEntity.dart';
import 'package:gmalpha_flutter/NewMessageModel/service/remote/entity/UnreadMessageEntity.dart';
import 'package:gmalpha_flutter/NewMessageModel/service/remote/entity/AttentionEntity.dart';
import 'package:rxdart/rxdart.dart';

class MessageRemote {
  static MessageRemote _userRemote;

  MessageRemote._() {}

  static MessageRemote getInstance() {
    if (_userRemote == null) {
      _userRemote = new MessageRemote._();
    }
    return _userRemote;
  }

  Observable<MyMessageEntity> getMyMessage(int page, int count) {
    return MessageApiImpl().getMyMessage(page, count);
  }

  Observable<UnreadMessageEntity> getUnreadMessage(int type) {
    return MessageApiImpl().getUnreadMessage(type);
  }

  Observable<LatestMessageEntity> getLatestMessage() {
    return MessageApiImpl().getLatestMessage();
  }

  Observable<AttentionEntity> getAttentionList(int page, int count) {
    return MessageApiImpl().getAttentionList(page, count);
  }

   Observable<LikePageEntity> getLikePage(int page, int count) {
    return MessageApiImpl().getLikePage(page, count);
  }

  Observable<FocusPageEntity> getFocusPage(int type, int page, int count) {
    return MessageApiImpl().getFocusPage(type, page, count);
  }
}
