
import 'package:gmalpha_flutter/Annotations/anno/Get.dart';
import 'package:gmalpha_flutter/Annotations/anno/Query.dart';
import 'package:gmalpha_flutter/Annotations/anno/ServiceCenter.dart';
import 'package:gmalpha_flutter/NewMessageModel/service/remote/entity/AttentionEntity.dart';
import 'package:gmalpha_flutter/NewMessageModel/service/remote/entity/FocusPageEntity.dart';
import 'package:gmalpha_flutter/NewMessageModel/service/remote/entity/LatestMessageEntity.dart';
import 'package:gmalpha_flutter/NewMessageModel/service/remote/entity/LikePageEntity.dart';
import 'package:gmalpha_flutter/NewMessageModel/service/remote/entity/MyMessageEntity.dart';
import 'package:gmalpha_flutter/NewMessageModel/service/remote/entity/UnreadMessageEntity.dart';

@ServiceCenter()
abstract class MessageApi{

  @Get("api/v1/message/my")
  MyMessageEntity getMyMessage(@Query('page') int page, @Query('count') int count);

  @Get("api/v1/message/unread")
  UnreadMessageEntity getUnreadMessage(@Query('type') int type);

  @Get('api/v1/push/newest/info')
  LatestMessageEntity getLatestMessage();

  @Get("api/v1/message/like")
  LikePageEntity getLikePage(@Query('page') int page, @Query('count') int count);
  
  @Get('api/v1/message/notice')
  AttentionEntity getAttentionList(@Query('page') int page, @Query('count') int count);

  @Get('/api/v1/follow/list')
  FocusPageEntity getFocusPage(@Query('type') int type, @Query('page') int page, @Query('count') int count);

}