class AttentionEntity {
  String message;
  int error;
  bool noData;
  List<Data> data;

  AttentionEntity({this.message, this.error, this.noData, this.data});

  AttentionEntity.fromJson(Map<String, dynamic> json) {
    message = json['message'];
    error = json['error'];
    noData = json['noData'];
    if (json['data'] != null) {
      data = new List<Data>();
      json['data'].forEach((v) {
        data.add(new Data.fromJson(v));
      });
    }
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['message'] = this.message;
    data['error'] = this.error;
    data['noData'] = this.noData;
    if (this.data != null) {
      data['data'] = this.data.map((v) => v.toJson()).toList();
    }
    return data;
  }
}

class Data {
  int id;
  String title;
  String content;
  String url;
  String icon;
  double pushTime;

  Data({this.id, this.title, this.content, this.url, this.icon, this.pushTime});

  Data.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    title = json['title'];
    content = json['content'];
    url = json['url'];
    icon = json['icon'];
    pushTime = json['push_time'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['id'] = this.id;
    data['title'] = this.title;
    data['content'] = this.content;
    data['url'] = this.url;
    data['icon'] = this.icon;
    data['push_time'] = this.pushTime;
    return data;
  }
}