class LikePageEntity {
  int error;
  String message;
  Null extra;
  List<Data> data;

  LikePageEntity({this.error, this.message, this.extra, this.data});

  LikePageEntity.fromJson(Map<String, dynamic> json) {
    error = json['error'];
    message = json['message'];
    extra = json['extra'];
    if (json['data'] != null) {
      data = new List<Data>();
      json['data'].forEach((v) {
        data.add(new Data.fromJson(v));
      });
    }
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['error'] = this.error;
    data['message'] = this.message;
    data['extra'] = this.extra;
    if (this.data != null) {
      data['data'] = this.data.map((v) => v.toJson()).toList();
    }
    return data;
  }
}

class Data {
  int userId;
  String name;
  String icon;
  double time;
  int type;
  LikeContent likeContent;
  int id;
  String content;
  bool unread;

  Data(
      {this.userId,
      this.name,
      this.icon,
      this.time,
      this.type,
      this.likeContent,
      this.id,
      this.content,
      this.unread});

  Data.fromJson(Map<String, dynamic> json) {
    userId = json['user_id'];
    name = json['name'];
    icon = json['icon'];
    time = json['time'];
    type = json['type'];
    likeContent = json['like_content'] != null
        ? new LikeContent.fromJson(json['like_content'])
        : null;
    id = json['id'];
    content = json['content'];
    unread = json['unread'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['user_id'] = this.userId;
    data['name'] = this.name;
    data['icon'] = this.icon;
    data['time'] = this.time;
    data['type'] = this.type;
    if (this.likeContent != null) {
      data['like_content'] = this.likeContent.toJson();
    }
    data['id'] = this.id;
    data['content'] = this.content;
    data['unread'] = this.unread;
    return data;
  }
}

class LikeContent {
  int type;
  int id;
  int contentType;
  String content;
  String replyContent;

  LikeContent(
      {this.type, this.id, this.contentType, this.content, this.replyContent});

  LikeContent.fromJson(Map<String, dynamic> json) {
    type = json['type'];
    id = json['id'];
    contentType = json['content_type'];
    content = json['content'];
    replyContent = json['reply_content'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['type'] = this.type;
    data['id'] = this.id;
    data['content_type'] = this.contentType;
    data['content'] = this.content;
    data['reply_content'] = this.replyContent;
    return data;
  }
}