class UnreadMessageEntity {
  int error;
  String message;
  Null extra;
  Data data;

  UnreadMessageEntity({this.error, this.message, this.extra, this.data});

  UnreadMessageEntity.fromJson(Map<String, dynamic> json) {
    error = json['error'];
    message = json['message'];
    extra = json['extra'];
    data = json['data'] != null ? new Data.fromJson(json['data']) : null;
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['error'] = this.error;
    data['message'] = this.message;
    data['extra'] = this.extra;
    if (this.data != null) {
      data['data'] = this.data.toJson();
    }
    return data;
  }
}

class Data {
  int count;
  int voteCount;
  int urgeCount;

  Data({this.count, this.voteCount, this.urgeCount});

  Data.fromJson(Map<String, dynamic> json) {
    count = json['count'];
    voteCount = json['vote_count'];
    urgeCount = json['urge_count'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['count'] = this.count;
    data['vote_count'] = this.voteCount;
    data['urge_count'] = this.urgeCount;
    return data;
  }
}