/*
 * @author lsy
 * @date   2019-09-16
 **/
import 'package:flutter/material.dart';
import 'package:gmalpha_flutter/Annotations/RouterCenterRestore.mark.dart';
import 'package:gmalpha_flutter/PrestigeModel/service/PrestigeRepository.dart';
import 'package:gmalpha_flutter/PrestigeModel/service/remote/entity/PrestigeEntity.dart';
import 'package:gmalpha_flutter/commonModel/live/BaseModel.dart';
import 'package:gmalpha_flutter/commonModel/live/LiveData.dart';
import 'package:gmalpha_flutter/commonModel/toast/toast.dart';

class ReputationsModel extends BaseModel {
  LiveData<PrestigeEntity> prestigeLive;
  LiveData<String> titleLive;

  final int userId;
  final String userName;
  final String fromPage;

  ReputationsModel(this.userId, this.userName, this.fromPage) {
    prestigeLive = new LiveData();
    titleLive = new LiveData();
  }

  init(BuildContext context) {
    titleLive.notifyView(userName);
    PrestigeRepository.getInstance().getReputations(userId).listen((value) {
      if (value != null) {
        prestigeLive.notifyView(value);
      }
    }).onError((error) {
      Toast.show(context, "${error.toString()}");
      print(error);
    });
  }

  @override
  void dispose() {
    prestigeLive.dispost();
    titleLive.dispost();
  }

  void pop(BuildContext context, String pageName) {
    RouterCenterImpl().findBuriedRouter()?.onClick(pageName, "return");
    Navigator.pop(context);
  }
}
