/*
 * @author lsy
 * @date   2019-10-13
 **/
import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:gmalpha_flutter/Annotations/RouterCenterRestore.mark.dart';
import 'package:gmalpha_flutter/commonModel/net/Api.dart';
import 'package:gmalpha_flutter/res/anim/Anim.dart';
import 'commonModel/GMBase.dart';

class TestPage extends StatelessWidget {
  TestPage() {
    Api.getInstance().setDioCookie({
      'Cookie':
          '_gm_token=709ed71571898502; sessionid=usixwh8e2bfykdsiq5ydt0ss6kfc0c26; _gtid=52ebb2a2f62611e9b181525400e82fab3838'
    });
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
        appBar: baseAppBar(title: "flutter测试", centerTitle: true),
        body: Container(
          child: ListView(
            children: <Widget>[
              testReportPage(context),
              presigePage(context),
              albumPage(context),
              userSettingPage(context),
              attentionPage(context),
              testMessagePage(context),
              likePage(context),
              focusPage(context),
            ],
          ),
        ));
  }

  base(BuildContext context, VoidCallback callback, String itemName) {
    return Container(
      margin: EdgeInsets.fromLTRB(16, 16, 16, 0),
      child: OutlineButton(
        onPressed: callback,
        child: Text(itemName),
      ),
    );
  }

  testMessagePage(BuildContext context) {
    return base(context, () {
      Navigator.push(
          context,
          new CustomRoute(
              RouterCenterImpl().findNewMessageRouter()?.getMessagePage('')));
    }, "消息页面");
  }

  testReportPage(BuildContext context) {
    return base(context, () {
      Navigator.push(
          context,
          new CustomRoute(RouterCenterImpl()
              .findActivityReportRouter()
              ?.getActivityReportPage(300, 1, '')));
    }, "报告页面");
  }

  presigePage(BuildContext context) {
    return base(context, () {
      Navigator.push(
          context,
          new CustomRoute(RouterCenterImpl()
              .findPrestigeRouter()
              ?.getReputationsPage(1, "ww", "ww")));
    }, "专家声望页面");
  }

  albumPage(BuildContext context) {
    return base(context, () {
      Navigator.push(
          context,
          new CustomRoute(RouterCenterImpl().findAlbumRouter()?.getAlbumPage(
              "com.example.gmalpha_flutter",
              true,
              9,
              null,
              false,
              "test",maxVideoCount: 1)));
    }, "相册页面");
  }

  userSettingPage(BuildContext context) {
    return base(context, () {
      Navigator.push(
          context,
          new CustomRoute(RouterCenterImpl()
              .findUserRouter()
              ?.getUserSettingPage("241765462", "NULL")));
    }, "设置页面");
  }

  attentionPage(BuildContext context) {
    return base(context, () {
      Navigator.push(
          context,
          new CustomRoute(RouterCenterImpl()
              .findNewMessageRouter()
              ?.getAttentionPage('message_home')));
    }, "通知页面");
  }

  likePage(BuildContext context) {
    return base(context, () {
      Navigator.push(
          context,
          new CustomRoute(RouterCenterImpl()
              .findNewMessageRouter()
              ?.getLikePage('message_home')));
    }, "like页面");
  }

  focusPage(BuildContext context) {
    return base(context, () {
      Navigator.push(
          context,
          new CustomRoute(RouterCenterImpl()
              .findNewMessageRouter()
              ?.getFocusPage('message_home')));
    }, "关注页面");
  }
}
