/*
 * @author lsy
 * @date   2019-10-08
 **/
import 'package:gmalpha_flutter/commonModel/cache/MemoryCache.dart';

const MEMORY_CACHE = "MEMORY_CACHE";
const SHARE_CACHE = "SHARE_CACHE";

class CacheManager {
  MemoryCache memoryCache;

  static CacheManager _instance = CacheManager._();

  CacheManager._() {
    memoryCache = new MemoryCache();
  }

  static CacheManager getInstance() {
    return _instance;
  }

  ICache get(String whichCache) {
    if (whichCache == MEMORY_CACHE) {
      return memoryCache;
    }
  }
}

class ICache {
  dynamic get(String key) {}

  void save(String key, dynamic value) {}
}
