import 'dart:async';
import 'dart:typed_data';
import 'package:flutter/material.dart';
import 'package:flutter/services.dart';

class AssestPlatformChannel extends StatefulWidget {
  @override
  _AssestPlatformChannelState createState() => _AssestPlatformChannelState();
}

class _AssestPlatformChannelState extends State<AssestPlatformChannel> {
  static const MethodChannel methodChannel =
      MethodChannel('GMAssetsMethodChannelName');
  static const EventChannel eventChannel =
      EventChannel('GMAssetsEventChannelName');

  Uint8List _imageData;
  String _tttt = 'ssss';


  Future<void> _editPortrait() async {
    Uint8List imageData;
    try {
      final result = await methodChannel.invokeMethod('editPortrait');
      imageData = result;
    } on PlatformException {
      imageData = null;
    }
    setState(() {
      _imageData = imageData;
      _tttt = _imageData.runtimeType.toString();
    });
  }

  @override
  void initState() {
    super.initState();
    eventChannel.receiveBroadcastStream().listen(_onEvent, onError: _onError);
  }

  void _onEvent(Object event) {
    setState(() {});
  }

  void _onError(Object error) {
    setState(() {});
  }

  @override
  Widget build(BuildContext context) {
    return Material(
      child: Scaffold(
        appBar: AppBar(
          title: Text('editPortrait test'),
        ),
        body: Center(
          child: Column(
            mainAxisAlignment: MainAxisAlignment.spaceEvenly,
            children: <Widget>[
              Column(
                mainAxisAlignment: MainAxisAlignment.center,
                children: <Widget>[
                  Text(_tttt, key: const Key('editPortrait')),
                  Padding(
                    padding: const EdgeInsets.all(16.0),
                    child: RaisedButton(
                      child: const Text('editPortrait'),
                      onPressed: _editPortrait,
                    ),
                  ),
                  Container(
                    color: Colors.pink[300],
                    width: 300,
                    height: 300,
                    child: _imageWidget()
                  )
                ],
              ),
            ],
          ),
        ),
      ),
    );
  }

  Widget _imageWidget(){
    if (_imageData != null) {
      return Image.memory(_imageData,
                      width: 200,
                      height: 200,
                    );
    }else{
      return Center(
        child: Text('I am not image'+_tttt),
      );
    }
  }

}
