import 'package:flutter/material.dart';
import 'package:flutter/rendering.dart';

class LayoutTest extends StatefulWidget {
  @override
  _LayoutTestState createState() => _LayoutTestState();
}

class _LayoutTestState extends State<LayoutTest> {
  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(
        title: Text('Layout Test'),
      ),
      body: Container(
        padding: EdgeInsets.all(32.0),
        child: Center(
          child: Column(
            children: <Widget>[
              _renderBoxTest(),
              _containerTestWidget()
            ],
          ),
        ),
      ),
    );
  }

Widget _renderBoxTest(){
  return Container(
        color: Colors.greenAccent,
        width:double.infinity,
        constraints: BoxConstraints(
            maxWidth: double.infinity,
            minWidth: 200.0,
            maxHeight: 200,
            minHeight: 100.0),
        child: Stingy(
          child: Container(
            color: Colors.pink[200],
          ),
        ),
      );
}

// www.baidu.com/img/bd_logo1.png
  Widget _containerTestWidget(){
    return Container(
      constraints: BoxConstraints.expand(
        height: Theme.of(context).textTheme.display1.fontSize * 1.1 + 200.0,
      ),
      padding: const EdgeInsets.all(8.0),
      color: Colors.greenAccent.shade700,
      alignment: Alignment.bottomCenter,
      child: Text('Hello World', style: Theme.of(context).textTheme.display1.copyWith(color: Colors.orange[200])),
      foregroundDecoration: BoxDecoration(
        image: DecorationImage(
          image: NetworkImage('https://www.example.com/images/frame.png'),
          centerSlice: Rect.fromLTRB(270.0, 180.0, 1360.0, 730.0),
        ),
      ),
      transform: Matrix4.rotationZ(0.1),
    );
  }
}


class Stingy extends SingleChildRenderObjectWidget {
  Stingy({Widget child}) : super(child: child);

  @override
  RenderObject createRenderObject(BuildContext context) {
    // TODO: implement createRenderObject
    return RenderStingy();
  }
}

class RenderStingy extends RenderShiftedBox {
  RenderStingy() : super(null);

  // 绘制方法
  @override
  void paint(PaintingContext context, Offset offset) {
    // TODO: implement paint
    super.paint(context, offset);
  }

  // 布局方法
  @override
  void performLayout() {
    // 布局 child 确定 child 的 size
    child.layout(
        BoxConstraints(
            minHeight: 0.0,
            maxHeight: constraints.minHeight,
            minWidth: 0.0,
            maxWidth: constraints.minWidth),
        parentUsesSize: true);

    print('constraints: $constraints');

    // child 的 Offset
    final BoxParentData childParentData = child.parentData;
    childParentData.offset = Offset(constraints.maxWidth - child.size.width,
        constraints.maxHeight - child.size.height);
    print('childParentData: $childParentData');

    // 确定自己（父节点）的大小，并重绘父节点。不重设，不能触发重绘，例如在热重载的情景中，重设container.maxHeight，无效
    size = Size(constraints.maxWidth, constraints.maxHeight);
    print('size: $size');
  }
}
