import 'package:flutter/material.dart';
import 'dart:ui' as ui;
import 'package:flutter/services.dart';

void main(){
  return runApp(new InviteSuccessPage());
}

class InviteSuccessPage extends StatelessWidget{
  @override
  Widget build(BuildContext context) {
    // TODO: implement build
    return MaterialApp(
        debugShowCheckedModeBanner: false,
        home: InviteSuccessContent(),
        theme: ThemeData(
            primaryColor: Colors.white,
            highlightColor: Colors.white,
            splashColor: Colors.white70)
    );
  }
}

class InviteSuccessContent extends StatelessWidget {
  BuildContext context;

  void onLeadingClick() {
    Navigator.pop(context);
  }

  @override
  Widget build(BuildContext context) {
    this.context = context;

    // TODO: implement build
    return Scaffold(
        backgroundColor: Colors.white,
        appBar: AppBar(
          elevation: 0.0,
          leading: IconButton(
              icon: Icon(Icons.arrow_back_ios), onPressed: onLeadingClick),
        ),
        body: Container(
          child: Center(
              child: Column(
                mainAxisAlignment: MainAxisAlignment.center,
                crossAxisAlignment: CrossAxisAlignment.center,
                children: <Widget>[
                  SizedBox(width: 10.0, height: 70.0),
                  Image(image: AssetImage('assets/image/1.0x/icon_invite_code_verify_success.png')),
                  SizedBox(width: 10.0, height: 40.0),
                  Text("帮助好友解锁成功",
                      style: TextStyle(fontSize: 20, fontWeight: FontWeight.bold)),
                  SizedBox(width: 10.0, height: 10.0),
                  Text("同时你已获赠3个可对比明星",
                      style: TextStyle(fontSize: 14, fontWeight: FontWeight.bold)),
                  SizedBox(width: 10.0, height: 50.0),
                  RaisedButton(
                    color: Colors.white,
                    child: Padding(
                        padding: EdgeInsets.fromLTRB(0, 15, 0, 15),
                        child: Text(
                          "去试试",
                          style: TextStyle(fontWeight: FontWeight.bold),
                        )),
                    elevation: 0.0,
                    padding: EdgeInsets.fromLTRB(50, 0, 50, 0),
                    onPressed: () {

                    },
                    shape: Border(
                        top: BorderSide(color: Colors.black, width: 2.0),
                        right: BorderSide(color: Colors.black, width: 2.0),
                        bottom: BorderSide(color: Colors.black, width: 2.0),
                        left: BorderSide(color: Colors.black, width: 2.0)),
                  ),
                  SizedBox(width: 10.0, height: 130.0),
                ],
              )),
        ));
  }
}
