import 'package:flutter/material.dart';
import 'package:gmalpha_flutter/commonModel/list_item.dart';

class NotificationModel extends ListItem {
  int id;
  String title;
  String content;
  String icon;
  int pushTime;
  String url;

  NotificationModel({this.id, this.title, this.content, this.icon, this.pushTime, this.url});

  NotificationModel.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    title = json['title'];
    content = json['content'];
    icon = json['icon'];
    pushTime = json['push_time'];
    url = json['url'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['id'] = this.id;
    data['title'] = this.title;
    data['content'] = this.content;
    data['icon'] = this.icon;
    data['push_time'] = this.pushTime;
    data['url'] = this.url;
    return data;
  }
}