/*
 * @author lsy
 * @date   2019-10-15
 **/
import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:flutter_screenutil/flutter_screenutil.dart';
import 'package:gmalpha_flutter/commonModel/base/BaseComponent.dart';
import 'package:gmalpha_flutter/commonModel/base/BasePage.dart';
import 'package:gmalpha_flutter/res/GMRes.dart';
import 'package:gmalpha_flutter/userModel/page/country/CountryModel.dart';
import 'package:gmalpha_flutter/userModel/service/remote/entity/CountryBean.dart';

class CountryPage extends StatefulWidget {
  CountryModel _model;

  CountryPage(String refer) {
    _model = new CountryModel(refer);
  }

  @override
  State<StatefulWidget> createState() => CountryState(_model);
}

class CountryState extends BasePage {
  CountryModel _model;

  CountryState(this._model);

  ScrollController _scrollController = new ScrollController();

  @override
  void initState() {
    super.initState();
    _model.getCountries(context);
    _scrollController.addListener(() {
      print(
          "lsyy  ${_scrollController.positions}  OFF  ${_scrollController.offset}");
    });
  }

  @override
  Widget build(BuildContext context) {
    ScreenUtil.instance = ScreenUtil(width: 375, height: 667)..init(context);
    return Scaffold(
      appBar: baseAppBar(
          centerTitle: true,
          title: "选择国家",
          backClick: () {
            Navigator.pop(context, _model.selectCity);
          }),
      body: StreamBuilder<CountryBean>(
        stream: _model.liveData.stream,
        initialData: _model.liveData.data,
        builder: (con, data) {
          if (data.data == null) {
            return loadingItem();
          } else {
            return ListView.builder(
                controller: _scrollController,
                itemCount: data.data?.data?.length,
                itemBuilder: (con, index) {
                  List<Widget> list = [];
                  list.add(headItem(data.data.data[index].title));
                  for (int i = 0;
                      i < data.data.data[index].countries.length;
                      i++) {
                    Countries countriy = data.data.data[index].countries[i];
                    list.add(countryItem(countriy));
                  }
                  return Column(
                    children: list,
                  );
                });
          }
        },
      ),
    );
  }

  headItem(String head) {
    return Container(
      color: Color(0x22000000),
      alignment: Alignment.centerLeft,
      height: ScreenUtil.instance.setHeight(25),
      padding: EdgeInsets.only(
        left: ScreenUtil.instance.setWidth(12),
      ),
      child: baseText(head, 15, ALColors.Color323232),
    );
  }

  countryItem(Countries country) {
    return GestureDetector(
        onTap: () {
          Navigator.pop(context,
              {"countryId": country.id, "countryName": country.name});
        },
        child: Container(
          alignment: Alignment.centerLeft,
          height: ScreenUtil.instance.setHeight(50),
          margin: EdgeInsets.only(
            left: ScreenUtil.instance.setWidth(12),
          ),
          child: baseText(country.name, 15, ALColors.Color323232),
        ));
  }

  @override
  void dispose() {
    super.dispose();
    _scrollController.dispose();
  }

  @override
  String pageName() {
    return "country_page";
  }

  @override
  String referrer() {
    return _model.refer;
  }
}
