/*
 * @author lsy
 * @date   2019-09-04
 **/
import 'package:gmalpha_flutter/Annotations/anno/Get.dart';
import 'package:gmalpha_flutter/Annotations/anno/Post.dart';
import 'package:gmalpha_flutter/Annotations/anno/Query.dart';
import 'package:gmalpha_flutter/Annotations/anno/ServiceCenter.dart';
import 'package:gmalpha_flutter/commonModel/net/Responce/SimpleResponce.dart';
import 'package:gmalpha_flutter/userModel/service/remote/entity/CommentBean.dart';
import 'package:gmalpha_flutter/userModel/service/remote/entity/CountryBean.dart';
import 'package:gmalpha_flutter/userModel/service/remote/entity/SetUserBean.dart';
import 'package:gmalpha_flutter/userModel/service/remote/entity/TestUserEntity.dart';
import 'package:gmalpha_flutter/userModel/service/remote/entity/UploadTokenBean.dart';
import 'package:gmalpha_flutter/userModel/service/remote/entity/UserEntity.dart';
import 'package:gmalpha_flutter/userModel/service/remote/entity/UserResultBean.dart';

@ServiceCenter()
abstract class UserApi {
  @Get("api/account/user_profile")
  UserResultBean getUserInfo(@Query("user_id") String userID);

  @Post("api/v1/suggestion")
  CommentBean comment(
      @Query("content") String content, @Query("phone") String phone);

  @Get("api/v1/countries")
  CountryBean getCountrys();

  /**
   * TODO not here！
   * 获取token api/v1/app/upload_token
   * <p>
   * 1, '图片' 2, '视频文件'3, 'face扫脸相关文件'
   */
  @Post("api/v1/app/upload_token")
  UploadTokenBean getUploadToken(@Query("token_type") int token_type);

  @Post("api/account/user_settle")
  SetUserBean settingUserInfo(
      @Query("country_id") String country_id,
      @Query("nick_name") String nick_name,
      @Query("profile_pic") String profile_pic,
      @Query("user_id") String user_id,
      @Query("age") String age);

  @Post("api/account/logout/")
  SimpleResponce logout(@Query("user_id") String user_id);
}
