import 'package:gmalpha_flutter/Annotations/anno/User.dart';
import 'package:gmalpha_flutter/Annotations/anno/UserCenter.dart';
import 'package:json_annotation/json_annotation.dart';

const String USER_ID = "user_uid";
const String NICKNAME = "username";
const String PORTRAIT = "potrait";
const String GENDER = "gender";
const String PERSONAL_QA = "personal_qa";
const String HAS_SCAN_FACE = "has_scan_face";
const String CURRENT_CITY_ID = "current_city_id";
const String QUESTION_URL = "question_url";
const String DETAIL_SETTED = "detail_setted";
const String BIRTHDAY = "birthday";
const String COUNTRY_ID = "country_id";
const String USER_BIND_MOBILE = "user_bind_mobile";
const String COUNTRY_LANGUAGE = "country_language";
const String COUNTRY_NAME = "country_name";
const String AGE = "user_age";

@UserCenter()
class UserEntity {
  /**
   * 用户id
   */
  @User(USER_ID, "")
  String userId;

  /**
   * 用户昵称
   */
  @User(NICKNAME, "")
  String nickName;

  /**
   * 用户头像
   */
  @User(PORTRAIT, "")
  String profilePic;

  /**
   * 是否需要答题
   */
  @User(PERSONAL_QA, true)
  bool hasAnswered = true;

  /**
   * 是否扫过脸
   */
  @User(HAS_SCAN_FACE, true)
  bool hasScanFace = false;

  String id;
  @User(GENDER, "")
  String gender;

  @User(CURRENT_CITY_ID, "")
  String cityId;

  @User(BIRTHDAY, 0.0)
  double birth;

  @User(COUNTRY_ID, "")
  String countryId;

  bool logined;

  // 用户是否设置过个人信息
  @User(DETAIL_SETTED, true)
  bool detailSetted = true;

  //用户是否选择了标签
  bool tagSetted = false;

  //注册流程中断后返回之前的登录页面
  @User(QUESTION_URL, "")
  String questionUrl;

  @User(USER_BIND_MOBILE, true)
  bool isBind;

  @User(COUNTRY_NAME, "")
  String countryInfoName;

  @User(COUNTRY_ID, "")
  String countryInfoId;

  @User(COUNTRY_LANGUAGE, "")
  String countryInfoLanguage;

  String insBindId;
  String registerTime;

  @User(AGE, "")
  String age;
}
