package com.example.gmalpha_flutter

import android.app.Activity
import android.content.Intent
import android.net.Uri
import android.os.Build
import android.os.Bundle
import android.support.v7.app.AppCompatActivity
import android.util.Log
import android.view.View
import com.taobao.idlefish.flutterboost.FlutterBoostPlugin
import com.taobao.idlefish.flutterboost.containers.BoostFlutterActivity

import io.flutter.app.FlutterActivity
import io.flutter.embedding.engine.plugins.FlutterPlugin
import io.flutter.plugin.common.MethodCall
import io.flutter.plugin.common.MethodChannel
import io.flutter.plugin.common.PluginRegistry
import io.flutter.plugins.GeneratedPluginRegistrant
import java.lang.ref.WeakReference
import java.util.HashMap

class MainActivity : FlutterActivity() {

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        GeneratedPluginRegistrant.registerWith(this)

        MethodChannel(flutterView, "flutter_bury_channel").setMethodCallHandler { call, result ->
            if (call.method == "FLUTTER_TO_H5") {

            } else if (call.method == "FLUTTER_TO_NATIVE") {

            } else if (call.method == "FLUTTER_BURIED") {
                val buriedMap = HashMap<String, Any>()
                //APPInfo
                buriedMap["app_name"] = "app_name"
                buriedMap["app_version_name"] = "app_version_name"
                buriedMap["channel"] = "channel"
                buriedMap["current_city_id"] = "current_city_id"
//                buriedMap["user_type"] = "user_type"
                //TODO
                //                        buriedMap.put("serial_id", serial_id++);
                buriedMap["grey_type"] = "unknown"

                //DeviceInfo
                buriedMap["device_id"] = "device_id"
                buriedMap["manufacturer"] = Build.MANUFACTURER
                buriedMap["lat"] = "lat"
                buriedMap["lng"] = "lng"
                buriedMap["is_WiFi"] = "is_WiFi"
                buriedMap["ip"] = "ip"
                buriedMap["model"] = Build.MODEL
                buriedMap["sys_version"] = Build.VERSION.RELEASE
                buriedMap["android_device_id"] = "android_device_id"

                buriedMap["user_id"] = "user_id"
                buriedMap["app_session_id"] = "app_session_id"
                buriedMap["create_at"] = (System.currentTimeMillis() / 1000).toString()
                buriedMap["version"] = "version"
                result.success(buriedMap)
            } else if (call.method == "GET_NET_TYPE") {
                result.success("wifi")
            } else if (call.method == "INIT_PARAMS") {
                val map = HashMap<String, String>()
                map.put("buildConfig", "debug")
                //HERE
                                        map.put("proxy", "172.30.9.84:6666");
                result.success(map)
            } else {
                result.notImplemented()
            }
        }
    }
}
