import 'dart:async';
import 'package:flutter/material.dart';
import 'package:gmalpha_flutter/ActivityReportModel/service/remote/entity/ActivityReportEntity.dart';

class AnimatedListSample extends StatefulWidget {
  final List<Cards> pictorialList;
  AnimatedListSample({Key key, this.pictorialList}) : super(key: key);
  @override
  _AnimatedListSampleState createState() => new _AnimatedListSampleState();
}

class _AnimatedListSampleState extends State<AnimatedListSample> {
  final GlobalKey<AnimatedListState> _listKey = new GlobalKey<AnimatedListState>();
  final List<Cards> _list = [];
  var _timer;

  @override
  void initState() {
    super.initState();
  }

  Widget _buildItem(BuildContext context, int index, Animation<double> animation) {
    return new CardItem(
      animation: animation,
      item: _list[index]
    );
  }

  @override
  Widget build(BuildContext context) {
    widget.pictorialList.forEach((item) {
      var index = widget.pictorialList.indexOf(item);
      var seconds = 500 * index;
      _timer = Timer(Duration(milliseconds: seconds), (){
        final int length=_list.length;
        _list.insert(length, item);
        _listKey.currentState.insertItem(length, duration: Duration(milliseconds: seconds));
      });
    });
    return Padding(
      padding: const EdgeInsets.all(16.0),
      child: new AnimatedList(
        key: _listKey,
        initialItemCount: _list.length,
        itemBuilder: _buildItem,
      ),
    );
  }

  @override
  void dispose() {
    super.dispose();
    _timer.dispose();
  }
}

class CardItem extends StatelessWidget {
  final Animation<double> animation;
  final item;
  CardItem({ Key key, this.animation, this.item }) : super(key: key);

  @override
  Widget build(BuildContext context) {
    TextStyle textStyle = Theme.of(context).textTheme.display1;
    return Padding(
      padding: const EdgeInsets.all(2.0),
      child: SizeTransition(
        axis: Axis.vertical,
        sizeFactor: animation,
        child: SizedBox(
          height: 100,
          child: Text('Item $item', style: textStyle),
        )
      )
    );
  }
}