import 'package:flutter/cupertino.dart';
import 'package:flutter_screenutil/flutter_screenutil.dart';
import 'package:gmalpha_flutter/commonModel/ui/ALColors.dart';

messageTitle(String text) {
  return Text(
    text,
    style: TextStyle(
      color: ALColors.Color323232,
      fontSize: ScreenUtil().setSp(20)
    )
  );
}

var width = ScreenUtil().setWidth(16);

messageTop(imgUrl, title, content, count) {
  var height = ScreenUtil().setHeight(12);
  return Container(
    padding: EdgeInsets.only(left: width, right: width),
    margin: EdgeInsets.only(right: ScreenUtil().setWidth(26)),
    width: double.infinity,
    decoration: BoxDecoration(
      color: ALColors.ColorFFFFFF,
      image: DecorationImage(
        image: AssetImage('images/arrow_right.png'),
        alignment: Alignment.centerRight
      )
    ),
    child: Stack(
      children: <Widget>[
        Container(
          padding: EdgeInsets.only(left: ScreenUtil().setWidth(28)),
          margin: EdgeInsets.only(left: ScreenUtil().setWidth(4), top: height, bottom: height),
          width: double.infinity,
          decoration: BoxDecoration(
            color: ALColors.ColorFFFFFF,
            image: DecorationImage(
              image: AssetImage(imgUrl),
              alignment: Alignment.centerLeft
            )
          ),
          child: Row(
            children: <Widget>[
              Text(
                title,
                style: TextStyle(
                  color: ALColors.Color323232,
                  fontSize: ScreenUtil().setSp(13),
                  fontWeight: FontWeight.bold
                )
              ),
              SizedBox(
                width: ScreenUtil().setWidth(16),
              ),
              Container(
                width: ScreenUtil().setWidth(200),
                child: Text(
                  content,
                  style: TextStyle(
                    color: ALColors.Color8E8E8E,
                    fontSize: ScreenUtil().setSp(13)
                  ),
                  maxLines: 1,
                  overflow: TextOverflow.ellipsis
                )
              )
            ],
          ),
        ),
        getNum(count)
      ],
    )
  );
}

getNum([int count]) {
  if(count > 0) {
    return Positioned(
      right: 0,
      top: ScreenUtil().setHeight(12),
      child: Container(
        padding: EdgeInsets.only(top: ScreenUtil().setHeight(2), bottom: ScreenUtil().setHeight(2), left: ScreenUtil().setWidth(7), right: ScreenUtil().setWidth(7)),
        decoration: BoxDecoration(
          color: ALColors.Color323232,
          borderRadius: BorderRadius.circular(22.0)
        ),
        child: Text(
          count.toString(),
          style: TextStyle(
            color: ALColors.ColorFFFFFF,
            fontSize: ScreenUtil().setSp(11),
            height: 1.0
          ),
        )
      ),
    );
  } else {
    return Container();
  }
}

messageList(list) {
  return Container(
    padding: EdgeInsets.only(left: width, right: width),
    margin: EdgeInsets.only(bottom: ScreenUtil().setHeight(25)),
    child: Row(
      crossAxisAlignment: CrossAxisAlignment.start,
      mainAxisAlignment: MainAxisAlignment.spaceBetween,
      children: <Widget>[
        Row(
          crossAxisAlignment: CrossAxisAlignment.start,
          mainAxisAlignment: MainAxisAlignment.start,
          children: <Widget>[
            Container(
              width: 42.0,
              height: 42.0,
              decoration: BoxDecoration(
                shape: BoxShape.circle,
                image: DecorationImage(
                  image: NetworkImage('http://alpha-s.gmeiapp.com/2018/12/23/c909726bc2-w')
                ),
              ),
            ),
            SizedBox(width: ScreenUtil().setWidth(10)),
            Container(
              child: Column(
                crossAxisAlignment: CrossAxisAlignment.start,
                mainAxisAlignment: MainAxisAlignment.start,
                children: <Widget>[
                  Row(
                    children: <Widget>[
                      Text(
                        '参白',
                        style: TextStyle(
                          color: ALColors.Color323232,
                          fontSize: ScreenUtil().setSp(13),
                          fontWeight: FontWeight.bold
                        )
                      ),
                      SizedBox(width: ScreenUtil().setWidth(10)),
                      Text(
                        '评论了你',
                        style: TextStyle(
                          color: ALColors.Color323232,
                          fontSize: ScreenUtil().setSp(13)
                        )
                      )
                    ],
                  ),
                  Text(
                    '半框眼镜真的很搭配',
                    style: TextStyle(
                      color: ALColors.Color323232,
                      fontSize: ScreenUtil().setSp(13)
                    ),
                    maxLines: 1,
                    overflow: TextOverflow.ellipsis
                  ),
                  Text(
                    '12小时',
                    style: TextStyle(
                      color: Color(0xfff8e8e8e),
                      fontSize: ScreenUtil().setSp(10)
                    )
                  )
                ],
              ),
            )
          ],
        ),
        Image.network(
          'http://alpha-s.gmeiapp.com/2018/12/24/2b9fca0930-w',
          width: ScreenUtil().setWidth(48),
          fit: BoxFit.fill,
        )
      ],
    )
  );
}
