class MyMessageEntity {
  int error;
  String message;
  Null extra;
  List<Data> data;

  MyMessageEntity({this.error, this.message, this.extra, this.data});

  MyMessageEntity.fromJson(Map<String, dynamic> json) {
    error = json['error'];
    message = json['message'];
    extra = json['extra'];
    if (json['data'] != null) {
      data = new List<Data>();
      json['data'].forEach((v) {
        data.add(new Data.fromJson(v));
      });
    }
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['error'] = this.error;
    data['message'] = this.message;
    data['extra'] = this.extra;
    if (this.data != null) {
      data['data'] = this.data.map((v) => v.toJson()).toList();
    }
    return data;
  }
}

class Data {
  int userId;
  String name;
  String icon;
  int id;
  bool isLike;
  double time;
  String content;
  RepliedContent repliedContent;

  Data(
      {this.userId,
      this.name,
      this.icon,
      this.id,
      this.isLike,
      this.time,
      this.content,
      this.repliedContent});

  Data.fromJson(Map<String, dynamic> json) {
    userId = json['user_id'];
    name = json['name'];
    icon = json['icon'];
    id = json['id'];
    isLike = json['is_like'];
    time = json['time'];
    content = json['content'];
    repliedContent = json['replied_content'] != null
        ? new RepliedContent.fromJson(json['replied_content'])
        : null;
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['user_id'] = this.userId;
    data['name'] = this.name;
    data['icon'] = this.icon;
    data['id'] = this.id;
    data['is_like'] = this.isLike;
    data['time'] = this.time;
    data['content'] = this.content;
    if (this.repliedContent != null) {
      data['replied_content'] = this.repliedContent.toJson();
    }
    return data;
  }
}

class RepliedContent {
  int id;
  int type;
  int topicId;
  int contentType;
  String content;

  RepliedContent(
      {this.id, this.type, this.topicId, this.contentType, this.content});

  RepliedContent.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    type = json['type'];
    topicId = json['topic_id'];
    contentType = json['content_type'];
    content = json['content'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['id'] = this.id;
    data['type'] = this.type;
    data['topic_id'] = this.topicId;
    data['content_type'] = this.contentType;
    data['content'] = this.content;
    return data;
  }
}