/*
 * @author lsy
 * @date   2019-09-16
 **/
import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:flutter_boost/flutter_boost.dart';
import 'package:gmalpha_flutter/Annotations/RouterCenterRestore.mark.dart';
import 'package:gmalpha_flutter/PrestigeModel/page/reputation/ReputationsModel.dart';
import 'package:gmalpha_flutter/PrestigeModel/service/remote/entity/PrestigeEntity.dart';
import 'package:cached_network_image/cached_network_image.dart';
import 'package:gmalpha_flutter/commonModel/base/BasePage.dart';
import 'package:flutter_svg/flutter_svg.dart';

class ReputationsPage extends StatefulWidget {
  ReputationsModel _model;

  ReputationsPage(int userId, String userName, String fromPage) {
    _model = new ReputationsModel(userId, userName, fromPage);
  }

  @override
  State<StatefulWidget> createState() => ReputationsState(_model);
}

class ReputationsState extends BasePage<ReputationsPage> {
  ReputationsModel _model;
  double screenWidth;

  ReputationsState(this._model);

  @override
  void initState() {
    super.initState();
    _model.init(context);
  }

  @override
  Widget build(BuildContext context) {
    screenWidth = MediaQuery.of(context).size.width;
    return Scaffold(
        appBar: AppBar(
            title: StreamBuilder<String>(
              stream: _model.titleLive.stream,
              initialData: _model.titleLive.data,
              builder: (context, data) {
                if (data.data == null) {
                  return MyText(16, '我的专家声望', 0xff323232);
                }
                String titleWord = '${data.data}的专家声望';
                if (titleWord.length > 10) {
                  titleWord = titleWord.substring(0, 10) + "...";
                }
                return MyText(16, titleWord, 0xff323232);
              },
            ),
            centerTitle: true,
            leading: GestureDetector(
              onTap: () {
                RouterCenterImpl()
                    .findBuriedRouter()
                    ?.onClick(pageName(), "return");
                Navigator.pop(context,"");
              },
//              child: Image.asset("images/nav_back.png"),
              child: Center(
                child: SvgPicture.asset("images/left_arrow.svg",
                    color: Color(0xff323232)),
              ),
            )),
        body: StreamBuilder<PrestigeEntity>(
          stream: _model.prestigeLive.stream,
          initialData: _model.prestigeLive.data,
          builder: (context, data) {
            if (data.data == null) {
              return loadingItem();
            }
            if (data.data.error != 0 || data.data.data == null) {
              return errorItem(data.data.message);
            }
            return CustomScrollView(
              slivers: <Widget>[
                SliverList(
                    delegate: SliverChildBuilderDelegate(
                        (BuildContext context, int index) {
                  if (index == 0) {
                    return Container(
                      margin: EdgeInsets.fromLTRB(17, 24, 17, 0),
                      child: MyText(16.0, data.data.data.introduce[0].question,
                          0xff323232),
                    );
                  }
                  if (index == 1) {
                    return Container(
                        margin: EdgeInsets.fromLTRB(19, 16, 19, 32),
                        child: Text(
                          data.data.data.introduce[0].answer,
                          style:
                              TextStyle(fontSize: 13, color: Color(0xff8E8E8E)),
                        ));
                  }
                  if (index == data.data.data.reputations.length + 2) {
                    //bottom margin
                    return Container(
                      height: 20,
                    );
                  }
                  return listItem(data, index - 2);
                }, childCount: data.data.data.reputations.length + 3)),
              ],
            );
          },
        ));
  }

  Widget listItem(AsyncSnapshot<PrestigeEntity> data, int index) {
    var item = data.data.data.reputations[index];
    int allSize;
    int bringSize = 0;
    if (item.expertTags == null) {
      allSize = 0;
      bringSize = 0;
    } else {
      allSize = item.expertTags.length;
      for (var item in item.expertTags) {
        if (item.level > 0) {
          bringSize = bringSize + 1;
        }
      }
    }
    double itemHeight = 164.0;
//    int col = (allSize / 3).ceil();
//    print("size   $col");
//    double allHeight;
//    if (col == 0) {
//      allHeight = 30;
//    } else {
//      allHeight = itemHeight * col;
//    }
    return Column(
      children: <Widget>[
        Container(
          color: Color(0xffDADADA),
          width: double.maxFinite,
          height: 30,
          child: Row(
            children: <Widget>[
              Container(
                margin: EdgeInsets.fromLTRB(16, 0, 0, 0),
                child: MyText(14.0, item.category, 0xffffffff),
              ),
              Expanded(
                child: Container(),
              ),
              Container(
                margin: EdgeInsets.fromLTRB(0, 0, 16, 0),
                child: MyText(14.0, "${bringSize}/${allSize}", 0xffffffff),
              )
            ],
          ),
        ),
        GridView.builder(
          physics: new NeverScrollableScrollPhysics(),
          shrinkWrap: true,
          itemCount: allSize,
          gridDelegate: SliverGridDelegateWithFixedCrossAxisCount(
              crossAxisCount: 3, childAspectRatio: 125 / itemHeight),
          itemBuilder: (context, gridIndex) {
            if (item.expertTags == null) {
              return Container();
            }
            bool isBright = item.expertTags[gridIndex].level > 0;
            return Container(
                child: Column(
              crossAxisAlignment: CrossAxisAlignment.center,
              children: <Widget>[
                Container(
                  height: 30,
                ),
                Container(
                  height: 80,
                  width: 80,
                  child: isBright
                      ? CachedNetworkImage(
                          imageUrl: item.expertTags[gridIndex].lightBadge)
                      : CachedNetworkImage(
                          imageUrl: item.expertTags[gridIndex].grayBadge),
                ),
                Container(
                    width: 100,
                    margin: EdgeInsets.fromLTRB(0, 5, 0, 0),
                    child: isBright
                        ? Center(
                            child: MyText(
                                13.0,
                                "Lv${item.expertTags[gridIndex].level} ${item.expertTags[gridIndex].tagName}",
                                0xff8E8E8E))
                        : Center(
                            child: MyText(
                                13.0,
                                "${item.expertTags[gridIndex].tagName}",
                                0xffC4C4C4))),
              ],
            ));
          },
        )
      ],
    );
  }

  Widget errorItem(String reason) {
    return Center(
      child: Text("$reason"),
    );
  }

  Widget loadingItem() {
    return Center(
      child: CircularProgressIndicator(),
    );
  }

  Text MyText(double size, String text, int color) {
    return Text(
      text,
      softWrap: true,
      maxLines: 2,
      overflow: TextOverflow.ellipsis,
      style: TextStyle(fontSize: size, color: Color(color)),
    );
  }

  @override
  void dispose() {
    _model.dispose();
    super.dispose();
  }

  @override
  String pageName() {
    return "my_expert_reputation";
  }

  @override
  String referrer() {
    return _model.fromPage;
  }
}
