/*
 * @author lsy
 * @date   2019-09-16
 **/

import 'package:gmalpha_flutter/PrestigeModel/service/local/PresitigeLocal.dart';
import 'package:gmalpha_flutter/PrestigeModel/service/remote/PrestigeRemote.dart';
import 'package:gmalpha_flutter/PrestigeModel/service/remote/entity/PrestigeEntity.dart';
import 'package:rxdart/rxdart.dart';

class PrestigeRepository {
  PrestigeRemote _remote;
  PresitigeLocal _local;

  static PrestigeRepository _userRepository;

  PrestigeRepository._() {
    _remote = PrestigeRemote.getInstance();
    _local = PresitigeLocal.getInstance();
  }

  static PrestigeRepository getInstance() {
    if (_userRepository == null) {
      _userRepository = PrestigeRepository._();
    }
    return _userRepository;
  }

  Observable<PrestigeEntity> getReputations(int userId) {
    return _remote.getReputations(userId).map((value) {
      if (value != null) {
      }
      return value;
    });
  }
}
