/*
 * @author lsy
 * @date   2019-10-13
 **/
import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:gmalpha_flutter/Annotations/RouterCenterRestore.mark.dart';
import 'package:gmalpha_flutter/commonModel/base/BaseComponent.dart';
import 'package:gmalpha_flutter/commonModel/net/Api.dart';
import 'package:gmalpha_flutter/res/anim/Anim.dart';

class TestPage extends StatelessWidget {
  TestPage() {
    Api.getInstance().setDioCookie({
      'Cookie':
          'sessionid=k96qdzwb3bquf87g32kdfbn676jkfnmk; _gtid=6bcbb61eebf411e9bfa4525400e82fab7541; _gm_token=e0fc1c1570864112'
    });
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
        appBar: baseAppBar(title: "flutter测试", centerTitle: true),
        body: Container(
          child: ListView(
            children: <Widget>[
              testReportPage(context),
              presigePage(context),
              albumPage(context),
              userSettingPage(context),
              testMessagePage(context),
            ],
          ),
        ));
  }

  base(BuildContext context, Widget page, String itemName) {
    return Container(
      margin: EdgeInsets.fromLTRB(16, 16, 16, 0),
      child: OutlineButton(
        onPressed: () {
          Navigator.push(
              context,
              new CustomRoute(page));
        },
        child: Text(itemName),
      ),
    );
  }

  testMessagePage(BuildContext context) {
    return base(
        context,
        RouterCenterImpl()
            .findNewMessageRouter()
            ?.getMessagePage(''),
        "消息页面");
  }

  testReportPage(BuildContext context) {
    return base(
        context,
        RouterCenterImpl()
            .findActivityReportRouter()
            ?.getActivityReportPage(2, 1, ''),
        "报告页面");
  }

  presigePage(BuildContext context) {
    return base(
        context,
        RouterCenterImpl()
            .findPrestigeRouter()
            ?.getReputationsPage(1, "ww", "ww"),
        "专家声望页面");
  }

  albumPage(BuildContext context) {
    return base(
        context,
        RouterCenterImpl().findAlbumRouter()?.getAlbumPage(
            "com.example.gengmei_flutter_plugin_example", true, 1, null),
        "相册页面");
  }

  userSettingPage(BuildContext context) {
    return base(
        context,
        RouterCenterImpl()
            .findUserRouter()
            ?.getUserSettingPage("241765462", "NULL"),
        "设置页面");
  }
}
