/*
 * @author lsy
 * @date   2019-10-13
 **/

import 'package:flutter/material.dart';
import 'package:flutter_svg/flutter_svg.dart';

AppBar baseAppBar(
    {String title, List<Widget> action, bool centerTitle, VoidCallback backClick}) {
  return AppBar(
    title: title == null ? Container() : baseText(title, 16, 0xff323232),
    centerTitle: centerTitle,
    leading: GestureDetector(
      onTap: backClick,
      child: Center(
          child: SvgPicture.asset(
        "images/left_arrow.svg",
        color: Color(0xff323232),
      )),
    ),
    actions: action == null ? List<Widget>() : action,
  );
}

Text baseText(String text, double fontSize, int color) {
  return Text(
    text,
    style: TextStyle(fontSize: fontSize, color: Color(color)),
  );
}
